/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.compatibility;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.potion.PotionType;

public class VersionedPotionType {
    public static final PotionType LEAPING;
    public static final PotionType SWIFTNESS;
    public static final PotionType HEALING;
    public static final PotionType HARMING;
    public static final PotionType REGENERATION;

    @Nullable
    private static PotionType getKey(@Nonnull String key) {
        try {
            Field field = PotionType.class.getDeclaredField(key);
            return (PotionType)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        MinecraftVersion version = Slimefun.getMinecraftVersion();
        LEAPING = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionType.LEAPING : VersionedPotionType.getKey("JUMP");
        SWIFTNESS = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionType.SWIFTNESS : VersionedPotionType.getKey("SPEED");
        HEALING = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionType.HEALING : VersionedPotionType.getKey("INSTANT_HEAL");
        HARMING = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionType.HARMING : VersionedPotionType.getKey("INSTANT_DAMAGE");
        REGENERATION = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionType.REGENERATION : VersionedPotionType.getKey("REGEN");
    }
}

