/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import javax.annotation.Nonnull;

public enum MinecraftVersion {
    MINECRAFT_1_16(16, "1.16.x"),
    MINECRAFT_1_17(17, "1.17.x"),
    MINECRAFT_1_18(18, "1.18.x"),
    MINECRAFT_1_19(19, "1.19.x"),
    MINECRAFT_1_20(20, 0, 4, "1.20.x"),
    MINECRAFT_1_20_5(20, 5, "1.20.5+"),
    UNKNOWN("Unknown", true),
    UNIT_TEST("Unit Test Environment", true);

    private final String name;
    private final boolean virtual;
    private final int majorVersion;
    private final int minorVersion;
    private final int maxMinorVersion;

    private MinecraftVersion(int majorVersion, String name) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = -1;
        this.maxMinorVersion = -1;
        this.virtual = false;
    }

    private MinecraftVersion(@Nonnull int majorVersion, int minor, String name) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minor;
        this.maxMinorVersion = -1;
        this.virtual = false;
    }

    private MinecraftVersion(int majorVersion, @Nonnull int minor, int maxMinorVersion, String name) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minor;
        this.maxMinorVersion = maxMinorVersion;
        this.virtual = false;
    }

    private MinecraftVersion(String name, boolean virtual) {
        this.name = name;
        this.majorVersion = 0;
        this.minorVersion = -1;
        this.maxMinorVersion = -1;
        this.virtual = virtual;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isMinecraftVersion(int minecraftVersion) {
        return this.isMinecraftVersion(minecraftVersion, -1);
    }

    public boolean isMinecraftVersion(int minecraftVersion, int patchVersion) {
        return !(this.isVirtual() || this.majorVersion != minecraftVersion || this.minorVersion != -1 && this.minorVersion > patchVersion || this.maxMinorVersion != -1 && patchVersion > this.maxMinorVersion);
    }

    public boolean isAtLeast(@Nonnull MinecraftVersion version) {
        Validate.notNull((Object)version, "A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return false;
        }
        if (this == UNIT_TEST && version.ordinal() == 0) {
            throw new IllegalArgumentException("Version " + String.valueOf((Object)version) + " is the lowest supported version already!");
        }
        return this.ordinal() >= version.ordinal();
    }

    public boolean isBefore(@Nonnull MinecraftVersion version) {
        Validate.notNull((Object)version, "A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return true;
        }
        return version.ordinal() > this.ordinal();
    }

    public boolean isBefore(int minecraftVersion, int patchVersion) {
        if (this.isVirtual()) {
            return false;
        }
        if (this.majorVersion != minecraftVersion) {
            return this.majorVersion < minecraftVersion;
        }
        return this.minorVersion == -1 ? patchVersion > 0 : this.minorVersion < patchVersion;
    }
}

