/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import javax.annotation.Nonnull;

public enum SlimefunBranch {
    DEVELOPMENT("development build", true),
    STABLE("\"stable\" build", true),
    UNOFFICIAL("Unofficial build", false),
    UNKNOWN("Unofficial build", false);

    private final String name;
    private final boolean official;

    private SlimefunBranch(String name, boolean official) {
        Validate.notNull(name, "The branch name cannot be null");
        this.name = name;
        this.official = official;
        if (!CommonPatterns.ASCII.matcher(name).matches()) {
            throw new IllegalStateException("The SlimefunBranch enum contains ILLEGAL CHARACTERS. DO NOT TRANSLATE THIS FILE.");
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isOfficial() {
        return this.official;
    }
}

