/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.protection.modules;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class GriefPreventionProtectionModule
implements ProtectionModule {
    private GriefPrevention griefPrevention;
    private boolean useClaimPermission = false;
    private final Plugin plugin;

    public GriefPreventionProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.griefPrevention = GriefPrevention.instance;
        try {
            Claim.class.getDeclaredMethod("checkPermission", Player.class, ClaimPermission.class, Event.class);
            this.useClaimPermission = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        World world = l.getWorld();
        if (world == null || !this.griefPrevention.claimsEnabledForWorld(world)) {
            return true;
        }
        Claim claim = this.griefPrevention.dataStore.getClaimAt(l, true, null);
        if (claim == null) {
            return true;
        }
        if (action == Interaction.ATTACK_PLAYER) {
            return !this.griefPrevention.claimIsPvPSafeZone(claim);
        }
        if (p.getUniqueId().equals(claim.ownerID)) {
            return true;
        }
        if (this.useClaimPermission) {
            return this.checkPermission(claim, p, action);
        }
        if (!(p instanceof Player)) {
            return false;
        }
        return this.checkLegacy(claim, (Player)p, action, l);
    }

    private boolean checkPermission(@Nonnull Claim claim, @Nonnull OfflinePlayer offline, @Nonnull Interaction action) {
        ClaimPermission permission = action == Interaction.INTERACT_BLOCK || action == Interaction.ATTACK_ENTITY ? ClaimPermission.Inventory : (action == Interaction.BREAK_BLOCK || action == Interaction.PLACE_BLOCK ? ClaimPermission.Build : ClaimPermission.Access);
        if (offline instanceof Player) {
            return claim.checkPermission((Player)offline, permission, null) == null;
        }
        return claim.checkPermission(offline.getUniqueId(), permission, null) == null;
    }

    private boolean checkLegacy(@Nonnull Claim claim, @Nonnull Player player, @Nonnull Interaction action, @Nonnull Location location) {
        switch (action) {
            case INTERACT_BLOCK: {
                return claim.allowContainers(player) == null;
            }
            case BREAK_BLOCK: {
                return claim.allowBreak(player, location.getBlock().getType()) == null;
            }
            case PLACE_BLOCK: {
                return claim.allowBuild(player, location.getBlock().getType()) == null;
            }
        }
        return claim.allowAccess(player) == null;
    }
}

