/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.storage.backend.legacy;

import com.google.common.annotations.Beta;
import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.storage.Storage;
import io.github.thebusybiscuit.slimefun4.storage.data.PlayerData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

@Beta
public class LegacyStorage
implements Storage {
    @Override
    public PlayerData loadPlayerData(@Nonnull UUID uuid) {
        long start = System.nanoTime();
        Config playerFile = new Config("data-storage/Slimefun/Players/" + uuid + ".yml");
        Config waypointsFile = new Config("data-storage/Slimefun/waypoints/" + uuid + ".yml");
        HashSet<Research> researches = new HashSet<Research>();
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (!playerFile.contains("researches." + research.getID())) continue;
            researches.add(research);
        }
        HashMap<Integer, PlayerBackpack> backpacks = new HashMap<Integer, PlayerBackpack>();
        for (String string : playerFile.getKeys("backpacks")) {
            try {
                int id = Integer.parseInt(string);
                int size = playerFile.getInt("backpacks." + string + ".size");
                HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < size; ++i) {
                    items.put(i, playerFile.getItem("backpacks." + string + ".contents." + i));
                }
                PlayerBackpack backpack = PlayerBackpack.load(uuid, id, size, items);
                backpacks.put(id, backpack);
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.WARNING, x, () -> "Could not load Backpack \"" + string + "\" for Player \"" + uuid + "\"");
            }
        }
        HashSet<Waypoint> hashSet = new HashSet<Waypoint>();
        for (String key : waypointsFile.getKeys()) {
            try {
                if (!waypointsFile.contains(key + ".world") || Bukkit.getWorld((String)waypointsFile.getString(key + ".world")) == null) continue;
                String waypointName = waypointsFile.getString(key + ".name");
                Location loc = waypointsFile.getLocation(key);
                hashSet.add(new Waypoint(uuid, key, loc, waypointName));
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.WARNING, x, () -> "Could not load Waypoint \"" + key + "\" for Player \"" + uuid + "\"");
            }
        }
        long l = System.nanoTime();
        Slimefun.getAnalyticsService().recordPlayerProfileDataTime("legacy", true, l - start);
        return new PlayerData(researches, backpacks, hashSet);
    }

    @Override
    public void savePlayerData(@Nonnull UUID uuid, @Nonnull PlayerData data) {
        long start = System.nanoTime();
        Config playerFile = new Config("data-storage/Slimefun/Players/" + uuid + ".yml");
        Config waypointsFile = new Config("data-storage/Slimefun/waypoints/" + uuid + ".yml");
        playerFile.setValue("rearches", null);
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (data.getResearches().contains(research)) {
                playerFile.setValue("researches." + research.getID(), true);
                continue;
            }
            if (!playerFile.contains("researches." + research.getID()) || data.getResearches().stream().anyMatch(r -> r.getID() == research.getID())) continue;
            playerFile.setValue("researches." + research.getID(), null);
        }
        for (PlayerBackpack backpack : data.getBackpacks().values()) {
            playerFile.setValue("backpacks." + backpack.getId() + ".size", backpack.getSize());
            for (int i = 0; i < backpack.getSize(); ++i) {
                ItemStack item = backpack.getInventory().getItem(i);
                if (item != null) {
                    playerFile.setValue("backpacks." + backpack.getId() + ".contents." + i, item);
                    continue;
                }
                if (!playerFile.contains("backpacks." + backpack.getId() + ".contents." + i)) continue;
                playerFile.setValue("backpacks." + backpack.getId() + ".contents." + i, null);
            }
        }
        waypointsFile.clear();
        for (Waypoint waypoint : data.getWaypoints()) {
            waypointsFile.setValue(waypoint.getId(), waypoint.getLocation());
            waypointsFile.setValue(waypoint.getId() + ".name", waypoint.getName());
        }
        playerFile.save();
        waypointsFile.save();
        long end = System.nanoTime();
        Slimefun.getAnalyticsService().recordPlayerProfileDataTime("legacy", false, end - start);
    }
}

