/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;

public class ArmorStandUtils {
    private ArmorStandUtils() {
    }

    @Nonnull
    public static ArmorStand spawnArmorStand(@Nonnull Location location, @Nonnull String customName) {
        ArmorStand armorStand = ArmorStandUtils.spawnArmorStand(location);
        armorStand.setCustomName(customName);
        armorStand.setCustomNameVisible(true);
        return armorStand;
    }

    @Nonnull
    public static ArmorStand spawnArmorStand(@Nonnull Location location) {
        if (PaperLib.getMinecraftVersion() < 20 || PaperLib.getMinecraftVersion() == 20 && PaperLib.getMinecraftPatchVersion() < 2) {
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            ArmorStandUtils.setupArmorStand(armorStand);
            return armorStand;
        }
        return (ArmorStand)location.getWorld().spawn(location, ArmorStand.class, ArmorStandUtils::setupArmorStand);
    }

    private static void setupArmorStand(ArmorStand armorStand) {
        armorStand.setVisible(false);
        armorStand.setSilent(true);
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        armorStand.setBasePlate(false);
        armorStand.setRemoveWhenFarAway(false);
    }
}

