/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.AbstractPluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.PluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdateInfo;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdaterTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.PrefixedVersion;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;

public class BlobBuildUpdater
extends AbstractPluginUpdater<PrefixedVersion> {
    private static final String SITE_URL = "https://blob.build";
    private static final String API_URL = "https://blob.build/api/builds";
    private final String project;
    private final String releaseChannel;

    public BlobBuildUpdater(@Nonnull Plugin plugin, @Nonnull File file, @Nonnull String project) {
        this(plugin, file, project, "Dev");
    }

    public BlobBuildUpdater(@Nonnull Plugin plugin, @Nonnull File file, @Nonnull String project, @Nonnull String releaseChannel) {
        super(plugin, file, BlobBuildUpdater.extractBuild(releaseChannel + " - ", plugin));
        this.project = project;
        this.releaseChannel = releaseChannel;
    }

    @Override
    public void start() {
        try {
            URL versionsURL = new URI("https://blob.build/api/builds/" + this.project + "/" + this.releaseChannel + "/latest").toURL();
            this.scheduleAsyncUpdateTask(new UpdaterTask<PrefixedVersion>((PluginUpdater)this, versionsURL){

                @Override
                public UpdateInfo parse(String result) throws MalformedURLException, URISyntaxException {
                    JsonObject json = (JsonObject)JsonParser.parseString((String)result);
                    if (json == null) {
                        BlobBuildUpdater.this.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to Blob.build, is it down?");
                        return null;
                    }
                    JsonObject data = json.getAsJsonObject("data");
                    int latestVersion = data.get("buildId").getAsInt();
                    URL downloadURL = new URI(data.get("fileDownloadUrl").getAsString()).toURL();
                    String checksum = data.get("checksum").getAsString();
                    PrefixedVersion latest = new PrefixedVersion(BlobBuildUpdater.this.releaseChannel + " - ", latestVersion);
                    BlobBuildUpdater.this.getLatestVersion().complete(latest);
                    return new UpdateInfo(downloadURL, latest, checksum);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", e);
        }
    }
}

