/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceInspector;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceRating;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SlimefunProfiler;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SummaryOrderType;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors.PlayerPerformanceInspector;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;

class PerformanceSummary {
    private static final int VISIBILITY_THRESHOLD = 260000;
    private static final int MIN_ITEMS = 6;
    private static final int MAX_ITEMS = 20;
    private final SlimefunProfiler profiler;
    private final PerformanceRating rating;
    private final long totalElapsedTime;
    private final int totalTickedBlocks;
    private final float percentage;
    private final int tickRate;
    private final Map<String, Long> chunks;
    private final Map<String, Long> plugins;
    private final Map<String, Long> items;

    PerformanceSummary(@Nonnull SlimefunProfiler profiler, long totalElapsedTime, int totalTickedBlocks) {
        this.profiler = profiler;
        this.rating = profiler.getPerformance();
        this.percentage = profiler.getPercentageOfTick();
        this.totalElapsedTime = totalElapsedTime;
        this.totalTickedBlocks = totalTickedBlocks;
        this.tickRate = profiler.getTickRate();
        this.chunks = profiler.getByChunk();
        this.plugins = profiler.getByPlugin();
        this.items = profiler.getByItem();
    }

    public void send(@Nonnull PerformanceInspector sender) {
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + "===== Slimefun Lag Profiler =====");
        sender.sendMessage(ChatColor.GOLD + "Total time: " + ChatColor.YELLOW + NumberUtils.getAsMillis(this.totalElapsedTime));
        sender.sendMessage(ChatColor.GOLD + "Running every: " + ChatColor.YELLOW + NumberUtils.roundDecimalNumber((double)this.tickRate / 20.0) + "s (" + this.tickRate + " ticks)");
        sender.sendMessage(ChatColor.GOLD + "Performance: " + this.getPerformanceRating());
        sender.sendMessage("");
        this.summarizeTimings(this.totalTickedBlocks, "block", sender, this.items, entry -> {
            int count = this.profiler.getBlocksOfId((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            String message = (String)entry.getKey() + " - " + count + "x (%s)";
            if (count <= 1) {
                return String.format(message, time);
            }
            String average = NumberUtils.getAsMillis((Long)entry.getValue() / (long)count);
            if (sender.getOrderType() == SummaryOrderType.AVERAGE) {
                return String.format(message, average + " | total: " + time);
            }
            return String.format(message, time + " | avg: " + average);
        });
        this.summarizeTimings(this.chunks.size(), "chunk", sender, this.chunks, entry -> {
            int count = this.profiler.getBlocksInChunk((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            return (String)entry.getKey() + " - " + count + " block" + (Serializable)(count != 1 ? Character.valueOf('s') : "") + " (" + time + ")";
        });
        this.summarizeTimings(this.plugins.size(), "plugin", sender, this.plugins, entry -> {
            int count = this.profiler.getBlocksFromPlugin((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            return (String)entry.getKey() + " - " + count + " block" + (Serializable)(count != 1 ? Character.valueOf('s') : "") + " (" + time + ")";
        });
    }

    @ParametersAreNonnullByDefault
    private void summarizeTimings(int count, String name, PerformanceInspector inspector, Map<String, Long> map, Function<Map.Entry<String, Long>, String> formatter) {
        Set<Map.Entry<String, Long>> entrySet = map.entrySet();
        List<Map.Entry<String, Long>> results = inspector.getOrderType().sort(this.profiler, entrySet);
        String prefix = count + " " + name + (Serializable)(count != 1 ? Character.valueOf('s') : "");
        if (inspector instanceof PlayerPerformanceInspector) {
            PlayerPerformanceInspector playerPerformanceInspector = (PlayerPerformanceInspector)inspector;
            TextComponent component = this.summarizeAsTextComponent(count, prefix, results, formatter);
            playerPerformanceInspector.sendMessage(component);
        } else {
            String text = this.summarizeAsString(inspector, count, prefix, results, formatter);
            inspector.sendMessage(text);
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private TextComponent summarizeAsTextComponent(int count, String prefix, List<Map.Entry<String, Long>> results, Function<Map.Entry<String, Long>, String> formatter) {
        TextComponent component = new TextComponent(prefix);
        component.setColor(ChatColor.YELLOW);
        if (count > 0) {
            TextComponent hoverComponent = new TextComponent("  (Hover for details)");
            hoverComponent.setColor(ChatColor.GRAY);
            StringBuilder builder = new StringBuilder();
            int shownEntries = 0;
            int hiddenEntries = 0;
            for (Map.Entry<String, Long> entry : results) {
                if (shownEntries < 20 && (shownEntries < 6 || entry.getValue() > 260000L)) {
                    builder.append("\n").append(ChatColor.YELLOW).append(formatter.apply(entry));
                    ++shownEntries;
                    continue;
                }
                ++hiddenEntries;
            }
            if (hiddenEntries > 0) {
                builder.append("\n\n&c+ &6").append(hiddenEntries).append(" more");
            }
            Text content = new Text(TextComponent.fromLegacyText((String)ChatColors.color(builder.toString())));
            hoverComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{content}));
            component.addExtra((BaseComponent)hoverComponent);
        }
        return component;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private String summarizeAsString(PerformanceInspector inspector, int count, String prefix, List<Map.Entry<String, Long>> results, Function<Map.Entry<String, Long>, String> formatter) {
        int shownEntries = 0;
        int hiddenEntries = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.GOLD).append(prefix);
        if (count > 0) {
            builder.append(ChatColor.YELLOW);
            for (Map.Entry<String, Long> entry : results) {
                if (inspector.isVerbose() || shownEntries < 20 && (shownEntries < 6 || entry.getValue() > 260000L)) {
                    builder.append("\n  ");
                    builder.append(ChatColor.stripColor((String)formatter.apply(entry)));
                    ++shownEntries;
                    continue;
                }
                ++hiddenEntries;
            }
            if (hiddenEntries > 0) {
                builder.append("\n+ ").append(hiddenEntries).append(" more...");
            }
        }
        return builder.toString();
    }

    @Nonnull
    private String getPerformanceRating() {
        StringBuilder builder = new StringBuilder();
        builder.append(NumberUtils.getColorFromPercentage(100.0f - Math.min(this.percentage, 100.0f)));
        int rest = 20;
        for (int i = (int)Math.min(this.percentage, 100.0f); i >= 5; i -= 5) {
            builder.append(':');
            --rest;
        }
        builder.append(ChatColor.DARK_GRAY).append(":".repeat(Math.max(0, rest))).append(" - ").append(this.rating.getColor()).append(ChatUtils.humanize(this.rating.name())).append(ChatColor.GRAY).append(" (").append(NumberUtils.roundDecimalNumber(this.percentage)).append("%)");
        return builder.toString();
    }
}

