/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceInspector;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SummaryOrderType;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.command.CommandSender;

public class ConsolePerformanceInspector
implements PerformanceInspector {
    private final CommandSender console;
    private final boolean verbose;
    private final SummaryOrderType orderType;

    @ParametersAreNonnullByDefault
    public ConsolePerformanceInspector(CommandSender console, boolean verbose, SummaryOrderType orderType) {
        Validate.notNull(console, "CommandSender cannot be null");
        Validate.notNull((Object)orderType, "SummaryOrderType cannot be null");
        this.console = console;
        this.verbose = verbose;
        this.orderType = orderType;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    @Nonnull
    public SummaryOrderType getOrderType() {
        return this.orderType;
    }

    @Override
    public void sendMessage(@Nonnull String msg) {
        this.console.sendMessage(msg);
    }
}

