/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.resources;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.resources.AbstractResource;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeMap;
import org.bukkit.World;
import org.bukkit.block.Biome;

class OilResource
extends AbstractResource {
    private static final int DEFAULT_OVERWORLD_VALUE = 10;
    private final BiomeMap<Integer> biomes;

    OilResource() {
        super("oil", "Oil", SlimefunItems.OIL_BUCKET, 8, false);
        MinecraftVersion version = Slimefun.getMinecraftVersion();
        this.biomes = version.isAtLeast(MinecraftVersion.MINECRAFT_1_18) ? OilResource.getBiomeMap(this, "/biome-maps/oil_v1.18.json") : OilResource.getBiomeMap(this, "/biome-maps/oil_v1.16.json");
    }

    @Override
    public int getDefaultSupply(World.Environment environment, Biome biome) {
        if (environment != World.Environment.NORMAL) {
            return 0;
        }
        return this.biomes.getOrDefault(biome, 10);
    }
}

