/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.runes;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnchantmentRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;
    private final Map<Material, List<Enchantment>> applicableEnchantments = new EnumMap<Material, List<Enchantment>>(Material.class);

    @ParametersAreNonnullByDefault
    public EnchantmentRune(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        for (Material mat : Material.values()) {
            ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
            for (Enchantment enchantment : Enchantment.values()) {
                if (enchantment.equals(Enchantment.BINDING_CURSE) || enchantment.equals(Enchantment.VANISHING_CURSE) || !enchantment.canEnchantItem(new ItemStack(mat))) continue;
                enchantments.add(enchantment);
            }
            this.applicableEnchantments.put(mat, enchantments);
        }
    }

    @Override
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (this.canUse(p, true)) {
                    Slimefun.runSync(() -> {
                        try {
                            this.addRandomEnchantment(p, item);
                        }
                        catch (Exception x) {
                            this.error("An Exception occurred while trying to apply an Enchantment Rune", x);
                        }
                    }, 20L);
                }
                return true;
            }
            return false;
        };
    }

    private void addRandomEnchantment(@Nonnull Player p, @Nonnull Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entites = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entites.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            List<Enchantment> potentialEnchantments = this.applicableEnchantments.get(itemStack.getType());
            if (potentialEnchantments == null) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.enchantment-rune.fail", true);
                return;
            }
            potentialEnchantments = new ArrayList<Enchantment>(potentialEnchantments);
            SlimefunItem slimefunItem = SlimefunItem.getByItem(itemStack);
            if (slimefunItem != null && !slimefunItem.isEnchantable()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.enchantment-rune.fail", true);
                return;
            }
            this.removeIllegalEnchantments(itemStack, potentialEnchantments);
            if (potentialEnchantments.isEmpty()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.enchantment-rune.no-enchantment", true);
                return;
            }
            Enchantment enchantment = potentialEnchantments.get(ThreadLocalRandom.current().nextInt(potentialEnchantments.size()));
            int level = this.getRandomlevel(enchantment);
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                Slimefun.runSync(() -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().spawnParticle(Particle.CRIT_MAGIC, l, 1);
                        SoundEffect.ENCHANTMENT_RUNE_ADD_ENCHANT_SOUND.playAt(l, SoundCategory.PLAYERS);
                        item.remove();
                        rune.remove();
                        itemStack.addEnchantment(enchantment, level);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.enchantment-rune.success", true);
                    }
                }, 10L);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.enchantment-rune.fail", true);
            }
        }
    }

    private int getRandomlevel(@Nonnull Enchantment enchantment) {
        int level = 1;
        if (enchantment.getMaxLevel() != 1) {
            level = ThreadLocalRandom.current().nextInt(enchantment.getMaxLevel()) + 1;
        }
        return level;
    }

    private void removeIllegalEnchantments(@Nonnull ItemStack target, @Nonnull List<Enchantment> potentialEnchantments) {
        for (Enchantment enchantment : target.getEnchantments().keySet()) {
            Iterator<Enchantment> iterator = potentialEnchantments.iterator();
            while (iterator.hasNext()) {
                Enchantment possibleEnchantment = iterator.next();
                if (!possibleEnchantment.equals(enchantment) && !possibleEnchantment.conflictsWith(enchantment)) continue;
                iterator.remove();
            }
        }
    }

    private boolean findCompatibleItem(@Nonnull Entity n) {
        if (n instanceof Item) {
            Item item = (Item)n;
            return !this.isItem(item.getItemStack());
        }
        return false;
    }
}

