/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public enum RadiationSymptom {
    SLOW(10, PotionEffectType.SLOW, 3),
    WITHER_LOW(25, PotionEffectType.WITHER, 0),
    BLINDNESS(50, PotionEffectType.BLINDNESS, 4),
    WITHER_HIGH(75, PotionEffectType.WITHER, 3),
    IMMINENT_DEATH(100, PotionEffectType.HARM, 49);

    private final int minExposure;
    private final PotionEffect potionEffect;

    private RadiationSymptom(int minExposure, PotionEffectType type, int level) {
        Preconditions.checkNotNull((Object)type, (Object)"The effect type cannot be null");
        Preconditions.checkArgument((minExposure > 0 ? 1 : 0) != 0, (Object)"The minimum exposure must be greater than 0.");
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (Object)"The status effect level must be non-negative.");
        this.minExposure = minExposure;
        this.potionEffect = new PotionEffect(type, Slimefun.getCfg().getOrSetDefault("options.radiation-update-interval", 1) * 20 + 20, level);
    }

    public void apply(@Nonnull Player p) {
        Preconditions.checkNotNull((Object)p, (Object)"The player cannot be null");
        p.addPotionEffect(this.potionEffect);
    }

    public boolean shouldApply(int exposure) {
        return exposure >= this.minExposure;
    }
}

