/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.storage.data;

import com.google.common.annotations.Beta;
import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@Beta
public class PlayerData {
    private final Set<Research> researches = new HashSet<Research>();
    private final Map<Integer, PlayerBackpack> backpacks = new HashMap<Integer, PlayerBackpack>();
    private final Set<Waypoint> waypoints = new HashSet<Waypoint>();

    public PlayerData(Set<Research> researches, Map<Integer, PlayerBackpack> backpacks, Set<Waypoint> waypoints) {
        this.researches.addAll(researches);
        this.backpacks.putAll(backpacks);
        this.waypoints.addAll(waypoints);
    }

    public Set<Research> getResearches() {
        return this.researches;
    }

    public void addResearch(@Nonnull Research research) {
        Validate.notNull(research, "Cannot add a 'null' research!");
        this.researches.add(research);
    }

    public void removeResearch(@Nonnull Research research) {
        Validate.notNull(research, "Cannot remove a 'null' research!");
        this.researches.remove(research);
    }

    @Nonnull
    public Map<Integer, PlayerBackpack> getBackpacks() {
        return this.backpacks;
    }

    @Nonnull
    public PlayerBackpack getBackpack(int id) {
        return this.backpacks.get(id);
    }

    public void addBackpack(@Nonnull PlayerBackpack backpack) {
        Validate.notNull(backpack, "Cannot add a 'null' backpack!");
        this.backpacks.put(backpack.getId(), backpack);
    }

    public void removeBackpack(@Nonnull PlayerBackpack backpack) {
        Validate.notNull(backpack, "Cannot remove a 'null' backpack!");
        this.backpacks.remove(backpack.getId());
    }

    public Set<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void addWaypoint(@Nonnull Waypoint waypoint) {
        Validate.notNull(waypoint, "Cannot add a 'null' waypoint!");
        for (Waypoint wp : this.waypoints) {
            if (!wp.getId().equals(waypoint.getId())) continue;
            throw new IllegalArgumentException("A Waypoint with that id already exists for this Player");
        }
        if (this.waypoints.size() >= 21) {
            return;
        }
        this.waypoints.add(waypoint);
    }

    public void removeWaypoint(@Nonnull Waypoint waypoint) {
        Validate.notNull(waypoint, "Cannot remove a 'null' waypoint!");
        this.waypoints.remove(waypoint);
    }
}

