/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.events.ExplosiveToolBreakBlocksEvent;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.events.ReactorExplodeEvent;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GoldPan;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.imprex.orebfuscator.api.OrebfuscatorService;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class OrebfuscatorIntegration
implements Listener {
    private final Slimefun plugin;
    private OrebfuscatorService service;

    OrebfuscatorIntegration(@Nonnull Slimefun plugin) {
        this.plugin = plugin;
    }

    public void register() {
        this.service = (OrebfuscatorService)Bukkit.getServer().getServicesManager().getRegistration(OrebfuscatorService.class).getProvider();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlacerPlace(BlockPlacerPlaceEvent event) {
        this.service.deobfuscate(Arrays.asList(event.getBlock(), event.getBlockPlacer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExplosiveToolBreakBlocks(ExplosiveToolBreakBlocksEvent event) {
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.addAll(event.getAdditionalBlocks());
        blocks.add(event.getPrimaryBlock());
        this.service.deobfuscate(blocks);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReactorExplode(ReactorExplodeEvent event) {
        this.service.deobfuscate(Arrays.asList(event.getLocation().getBlock()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGoldPanUse(PlayerRightClickEvent event) {
        if (event.getSlimefunItem().isPresent() && event.getClickedBlock().isPresent() && event.getSlimefunItem().get() instanceof GoldPan) {
            this.service.deobfuscate(List.of(event.getClickedBlock().get()));
        }
    }
}

