/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class LimitedUseItem
extends SimpleSlimefunItem<ItemUseHandler> {
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)Slimefun.instance(), "uses_left");
    private int maxUseCount = -1;

    @ParametersAreNonnullByDefault
    protected LimitedUseItem(ItemGroup group, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(group, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public final int getMaxUseCount() {
        return this.maxUseCount;
    }

    @Nonnull
    public final LimitedUseItem setMaxUseCount(int count) {
        Validate.isTrue(count > 0, "The maximum use count must be greater than zero!");
        this.maxUseCount = count;
        return this;
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        if (this.getMaxUseCount() < 1) {
            this.warn("The use count has not been configured correctly. It needs to be at least 1. The Item was disabled.");
        } else {
            super.register(addon);
        }
    }

    @ParametersAreNonnullByDefault
    protected void damageItem(Player p, ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
            ItemStack separateItem = item.clone();
            separateItem.setAmount(1);
            this.damageItem(p, separateItem);
            if (!p.getInventory().addItem(new ItemStack[]{separateItem}).isEmpty()) {
                p.getWorld().dropItemNaturally(p.getLocation(), separateItem);
            }
        } else {
            ItemMeta meta = item.getItemMeta();
            NamespacedKey key = this.getStorageKey();
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            int usesLeft = (Integer)pdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)this.getMaxUseCount());
            if (usesLeft == 1) {
                SoundEffect.LIMITED_USE_ITEM_BREAK_SOUND.playFor(p);
                item.setAmount(0);
                item.setType(Material.AIR);
            } else {
                pdc.set(key, PersistentDataType.INTEGER, (Object)(--usesLeft));
                this.updateItemLore(item, meta, usesLeft);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void updateItemLore(ItemStack item, ItemMeta meta, int usesLeft) {
        List lore = meta.getLore();
        String newLine = ChatColors.color(LoreBuilder.usesLeft(usesLeft));
        if (lore != null && !lore.isEmpty()) {
            for (int i = 0; i < lore.size(); ++i) {
                if (!PatternUtils.USES_LEFT_LORE.matcher((CharSequence)lore.get(i)).matches()) continue;
                lore.set(i, newLine);
                meta.setLore(lore);
                item.setItemMeta(meta);
                return;
            }
        } else {
            meta.setLore(Collections.singletonList(newLine));
            item.setItemMeta(meta);
        }
    }
}

