/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.exceptions.TagMisconfigurationException;
import io.github.thebusybiscuit.slimefun4.api.gps.GPSNetwork;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.networks.NetworkManager;
import io.github.thebusybiscuit.slimefun4.core.services.AutoSavingService;
import io.github.thebusybiscuit.slimefun4.core.services.BackupService;
import io.github.thebusybiscuit.slimefun4.core.services.BlockDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomItemDataService;
import io.github.thebusybiscuit.slimefun4.core.services.CustomTextureService;
import io.github.thebusybiscuit.slimefun4.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.core.services.MetricsService;
import io.github.thebusybiscuit.slimefun4.core.services.MinecraftRecipeService;
import io.github.thebusybiscuit.slimefun4.core.services.PerWorldSettingsService;
import io.github.thebusybiscuit.slimefun4.core.services.PermissionsService;
import io.github.thebusybiscuit.slimefun4.core.services.UpdaterService;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.holograms.HologramsService;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SlimefunProfiler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundService;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.StartupWarnings;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientAltar;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientPedestal;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.Cooler;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.BeeWings;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GrapplingHook;
import io.github.thebusybiscuit.slimefun4.implementation.items.weapons.SeismicAxe;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AutoCrafterListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BackpackListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BeeWingsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.BlockPhysicsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ButcherAndroidListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.CargoNodeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.CoolerListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DeathpointListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DebugFishListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.DispenserListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ElytraImpactListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.EnhancedFurnaceListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ExplosionsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GadgetsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.HopperListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ItemDropListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.ItemPickupListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.JoinListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MiddleClickListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MiningAndroidListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.MultiBlockListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.NetworkListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.PlayerProfileListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.RadioactivityListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SeismicAxeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBootsListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunBowListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunGuideListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemConsumeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemHitListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SlimefunItemInteractListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.SoulboundListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.TalismanListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.VillagerTradingListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.AnvilListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.BrewingStandListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.CartographyTableListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.CauldronListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.CraftingTableListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.GrindstoneListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.SmithingTableListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.BeeListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.EntityInteractionListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.FireworksListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.IronGolemListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.MobDropListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.PiglinListener;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.entity.WitherListener;
import io.github.thebusybiscuit.slimefun4.implementation.resources.GEOResourcesSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.PostSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.ResearchSetup;
import io.github.thebusybiscuit.slimefun4.implementation.setup.SlimefunItemSetup;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.SlimefunStartupTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.TickerTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.RadiationTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.RainbowArmorTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.SlimefunArmorTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.SolarHelmetTask;
import io.github.thebusybiscuit.slimefun4.integrations.IntegrationsManager;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionManager;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.storage.Storage;
import io.github.thebusybiscuit.slimefun4.storage.backend.legacy.LegacyStorage;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.MenuListener;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitTask;

public final class Slimefun
extends JavaPlugin
implements SlimefunAddon {
    private static final int RECOMMENDED_JAVA_VERSION = 17;
    private static Slimefun instance;
    private MinecraftVersion minecraftVersion = MinecraftVersion.UNKNOWN;
    private boolean isNewlyInstalled = false;
    private final SlimefunRegistry registry = new SlimefunRegistry();
    private final SlimefunCommand command = new SlimefunCommand(this);
    private final TickerTask ticker = new TickerTask();
    private final CustomItemDataService itemDataService = new CustomItemDataService((Plugin)this, "slimefun_item");
    private final BlockDataService blockDataService = new BlockDataService((Plugin)this, "slimefun_block");
    private final CustomTextureService textureService = new CustomTextureService(new Config((Plugin)this, "item-models.yml"));
    private final GitHubService gitHubService = new GitHubService("Slimefun/Slimefun4");
    private final UpdaterService updaterService = new UpdaterService(this, this.getDescription().getVersion(), this.getFile());
    private final MetricsService metricsService = new MetricsService(this);
    private final AutoSavingService autoSavingService = new AutoSavingService();
    private final BackupService backupService = new BackupService();
    private final PermissionsService permissionsService = new PermissionsService(this);
    private final PerWorldSettingsService worldSettingsService = new PerWorldSettingsService(this);
    private final MinecraftRecipeService recipeService = new MinecraftRecipeService((Plugin)this);
    private final HologramsService hologramsService = new HologramsService((Plugin)this);
    private final SoundService soundService = new SoundService(this);
    private final IntegrationsManager integrations = new IntegrationsManager(this);
    private final SlimefunProfiler profiler = new SlimefunProfiler();
    private final GPSNetwork gpsNetwork = new GPSNetwork(this);
    private NetworkManager networkManager;
    private LocalizationService local;
    private final Config config = new Config((Plugin)this);
    private final Config items = new Config((Plugin)this, "Items.yml");
    private final Config researches = new Config((Plugin)this, "Researches.yml");
    private Storage playerStorage;
    private final GrapplingHookListener grapplingHookListener = new GrapplingHookListener();
    private final BackpackListener backpackListener = new BackpackListener();
    private final SlimefunBowListener bowListener = new SlimefunBowListener();

    public Slimefun() {
    }

    @ParametersAreNonnullByDefault
    public Slimefun(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.minecraftVersion = MinecraftVersion.UNIT_TEST;
    }

    public void onEnable() {
        Slimefun.setInstance(this);
        if (this.isUnitTest()) {
            this.onUnitTestStart();
        } else if (this.isVersionUnsupported()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.onPluginStart();
        }
    }

    private void onUnitTestStart() {
        this.local = new LocalizationService(this, "", null);
        this.networkManager = new NetworkManager(200);
        this.command.register();
        this.registry.load(this, this.config);
        this.loadTags();
        this.soundService.reload(false);
        this.playerStorage = new LegacyStorage();
    }

    private void onPluginStart() {
        long timestamp = System.nanoTime();
        Logger logger = this.getLogger();
        if (PaperLib.isPaper()) {
            logger.log(Level.INFO, "Paper was detected! Performance optimizations have been applied.");
        } else {
            PaperLib.suggestPaper((Plugin)this);
        }
        if (this.getServer().getPluginManager().getPlugin("CS-CoreLib") != null) {
            StartupWarnings.discourageCSCoreLib(logger);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (NumberUtils.getJavaVersion() < 17) {
            StartupWarnings.oldJavaVersion(logger, 17);
        }
        this.isNewlyInstalled = !new File("data-storage/Slimefun").exists();
        logger.log(Level.INFO, "Creating directories...");
        this.createDirectories();
        this.registry.load(this, this.config);
        logger.log(Level.INFO, "Loading language files...");
        String chatPrefix = this.config.getString("options.chat-prefix");
        String serverDefaultLanguage = this.config.getString("options.language");
        this.local = new LocalizationService(this, chatPrefix, serverDefaultLanguage);
        int networkSize = this.config.getInt("networks.max-size");
        if (networkSize < 1) {
            logger.log(Level.WARNING, "Your 'networks.max-size' setting is misconfigured! It must be at least 1, it was set to: {0}", networkSize);
            networkSize = 1;
        }
        this.networkManager = new NetworkManager(networkSize, this.config.getBoolean("networks.enable-visualizer"), this.config.getBoolean("networks.delete-excess-items"));
        this.playerStorage = new LegacyStorage();
        logger.log(Level.INFO, "Using legacy storage for player data");
        new Thread(this.metricsService::start, "Slimefun Metrics").start();
        if (this.config.getBoolean("options.auto-update")) {
            logger.log(Level.INFO, "Starting Auto-Updater...");
            this.updaterService.start();
        } else {
            this.updaterService.disable();
        }
        logger.log(Level.INFO, "Loading GEO-Resources...");
        GEOResourcesSetup.setup();
        logger.log(Level.INFO, "Loading Tags...");
        this.loadTags();
        logger.log(Level.INFO, "Loading items...");
        this.loadItems();
        logger.log(Level.INFO, "Loading researches...");
        this.loadResearches();
        this.registry.setResearchingEnabled(Slimefun.getResearchCfg().getBoolean("enable-researching"));
        PostSetup.setupWiki();
        logger.log(Level.INFO, "Registering listeners...");
        this.registerListeners();
        Slimefun.runSync(new SlimefunStartupTask(this, () -> {
            this.textureService.register(this.registry.getAllSlimefunItems(), true);
            this.permissionsService.register(this.registry.getAllSlimefunItems(), true);
            this.soundService.reload(true);
            try {
                this.recipeService.refresh();
            }
            catch (Exception | LinkageError x) {
                logger.log(Level.SEVERE, x, () -> "An Exception occurred while iterating through the Recipe list on Minecraft Version " + this.minecraftVersion.getName() + " (Slimefun v" + Slimefun.getVersion() + ")");
            }
        }), 0L);
        try {
            this.command.register();
        }
        catch (Exception | LinkageError x) {
            logger.log(Level.SEVERE, "An Exception occurred while registering the /slimefun command", x);
        }
        if (this.config.getBoolean("options.enable-armor-effects")) {
            new SlimefunArmorTask().schedule(this, (long)this.config.getInt("options.armor-update-interval") * 20L);
            if (this.config.getBoolean("options.enable-radiation")) {
                new RadiationTask().schedule(this, (long)this.config.getInt("options.radiation-update-interval") * 20L);
            }
            new RainbowArmorTask().schedule(this, (long)this.config.getInt("options.rainbow-armor-update-interval") * 20L);
            new SolarHelmetTask().schedule(this, this.config.getInt("options.armor-update-interval"));
        } else if (this.config.getBoolean("options.enable-radiation")) {
            logger.log(Level.WARNING, "Cannot enable radiation while armor effects are disabled.");
        }
        this.autoSavingService.start(this, this.config.getInt("options.auto-save-delay-in-minutes"));
        this.hologramsService.start();
        this.ticker.start(this);
        logger.log(Level.INFO, "Loading Third-Party plugin integrations...");
        this.integrations.start();
        this.gitHubService.start(this);
        logger.log(Level.INFO, "Slimefun has finished loading in {0}", this.getStartupTime(timestamp));
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Override
    public String getBugTrackerURL() {
        return "https://github.com/Slimefun/Slimefun4/issues";
    }

    public void onDisable() {
        if (Slimefun.instance() == null || this.minecraftVersion == MinecraftVersion.UNIT_TEST) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        try {
            this.ticker.halt();
            this.ticker.run();
        }
        catch (Exception x) {
            this.getLogger().log(Level.SEVERE, x, () -> "Something went wrong while disabling the ticker task for Slimefun v" + this.getDescription().getVersion());
        }
        this.profiler.kill();
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (Map.Entry<String, BlockStorage> entry : Slimefun.getRegistry().getWorlds().entrySet()) {
            try {
                entry.getValue().saveAndRemove();
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while saving Slimefun-Blocks in World '" + (String)entry.getKey() + "' for Slimefun " + Slimefun.getVersion());
            }
        }
        for (UniversalBlockMenu menu : this.registry.getUniversalInventories().values()) {
            menu.save();
        }
        if (this.config.getBoolean("options.backup-data")) {
            this.backupService.run();
        }
        this.metricsService.cleanUp();
        Slimefun.setInstance(null);
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private static void setInstance(@Nullable Slimefun pluginInstance) {
        instance = pluginInstance;
    }

    @Nonnull
    private String getStartupTime(long timestamp) {
        long ms = (System.nanoTime() - timestamp) / 1000000L;
        if (ms > 1000L) {
            return NumberUtils.roundDecimalNumber((double)ms / 1000.0) + "s";
        }
        return NumberUtils.roundDecimalNumber(ms) + "ms";
    }

    public boolean isUnitTest() {
        return this.minecraftVersion == MinecraftVersion.UNIT_TEST;
    }

    private boolean isVersionUnsupported() {
        try {
            if (!PaperLib.isSpigot() && Bukkit.getName().equals("CraftBukkit")) {
                StartupWarnings.invalidServerSoftware(this.getLogger());
                return true;
            }
            int version = PaperLib.getMinecraftVersion();
            if (version > 0) {
                for (MinecraftVersion supportedVersion : MinecraftVersion.values()) {
                    if (!supportedVersion.isMinecraftVersion(version)) continue;
                    this.minecraftVersion = supportedVersion;
                    return false;
                }
                StartupWarnings.invalidMinecraftVersion(this.getLogger(), version, this.getDescription().getVersion());
                return true;
            }
            this.getLogger().log(Level.WARNING, "We could not determine the version of Minecraft you were using? ({0})", Bukkit.getVersion());
            return false;
        }
        catch (Exception | LinkageError x) {
            this.getLogger().log(Level.SEVERE, x, () -> "Error: Could not determine Environment or version of Minecraft for Slimefun v" + this.getDescription().getVersion());
            return true;
        }
    }

    @Nonnull
    static Collection<String> getSupportedVersions() {
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftVersion version : MinecraftVersion.values()) {
            if (version.isVirtual()) continue;
            list.add(version.getName());
        }
        return list;
    }

    private void createDirectories() {
        File file;
        String[] storageFolders = new String[]{"Players", "blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
        String[] pluginFolders = new String[]{"scripts", "error-reports", "cache/github", "world-settings"};
        for (String folder : storageFolders) {
            file = new File("data-storage/Slimefun", folder);
            if (file.exists()) continue;
            file.mkdirs();
        }
        for (String folder : pluginFolders) {
            file = new File("plugins/Slimefun", folder);
            if (file.exists()) continue;
            file.mkdirs();
        }
    }

    private void registerListeners() {
        new MenuListener((Plugin)this);
        new SlimefunBootsListener(this);
        new SlimefunItemInteractListener(this);
        new SlimefunItemConsumeListener(this);
        new BlockPhysicsListener(this);
        new CargoNodeListener(this);
        new MultiBlockListener(this);
        new GadgetsListener(this);
        new DispenserListener(this);
        new BlockListener(this);
        new EnhancedFurnaceListener(this);
        new ItemPickupListener(this);
        new ItemDropListener(this);
        new DeathpointListener(this);
        new ExplosionsListener(this);
        new DebugFishListener(this);
        new FireworksListener(this);
        new WitherListener(this);
        new IronGolemListener(this);
        new EntityInteractionListener(this);
        new MobDropListener(this);
        new VillagerTradingListener(this);
        new ElytraImpactListener(this);
        new CraftingTableListener(this);
        new AnvilListener(this);
        new BrewingStandListener(this);
        new CauldronListener(this);
        new GrindstoneListener(this);
        new CartographyTableListener(this);
        new ButcherAndroidListener(this);
        new MiningAndroidListener(this);
        new NetworkListener(this, this.networkManager);
        new HopperListener(this);
        new TalismanListener(this);
        new SoulboundListener(this);
        new AutoCrafterListener(this);
        new SlimefunItemHitListener(this);
        new MiddleClickListener(this);
        new BeeListener(this);
        new BeeWingsListener(this, (BeeWings)SlimefunItems.BEE_WINGS.getItem());
        new PiglinListener(this);
        new SmithingTableListener(this);
        new JoinListener(this);
        new CoolerListener(this, (Cooler)SlimefunItems.COOLER.getItem());
        new SeismicAxeListener(this, (SeismicAxe)SlimefunItems.SEISMIC_AXE.getItem());
        new RadioactivityListener(this);
        new AncientAltarListener(this, (AncientAltar)SlimefunItems.ANCIENT_ALTAR.getItem(), (AncientPedestal)SlimefunItems.ANCIENT_PEDESTAL.getItem());
        this.grapplingHookListener.register(this, (GrapplingHook)SlimefunItems.GRAPPLING_HOOK.getItem());
        this.bowListener.register(this);
        this.backpackListener.register(this);
        new SlimefunGuideListener(this, this.config.getBoolean("guide.receive-on-first-join"));
        new PlayerProfileListener(this);
    }

    private void loadTags() {
        for (SlimefunTag tag : SlimefunTag.values()) {
            try {
                if (!tag.isEmpty()) continue;
                tag.reload();
            }
            catch (TagMisconfigurationException e) {
                this.getLogger().log(Level.SEVERE, e, () -> "Failed to load Tag: " + tag.name());
            }
        }
    }

    private void loadItems() {
        try {
            SlimefunItemSetup.setup(this);
        }
        catch (Exception | LinkageError x) {
            this.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while initializing SlimefunItems for Slimefun " + Slimefun.getVersion());
        }
    }

    private void loadResearches() {
        try {
            ResearchSetup.setupResearches();
        }
        catch (Exception | LinkageError x) {
            this.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while initializing Slimefun Researches for Slimefun " + Slimefun.getVersion());
        }
    }

    @Nullable
    public static Slimefun instance() {
        return instance;
    }

    private static void validateInstance() {
        if (instance == null) {
            throw new IllegalStateException("Cannot invoke static method, Slimefun instance is null.");
        }
    }

    @Nonnull
    public static Logger logger() {
        Slimefun.validateInstance();
        return instance.getLogger();
    }

    @Nonnull
    public static String getVersion() {
        Slimefun.validateInstance();
        return instance.getDescription().getVersion();
    }

    @Nonnull
    public static Config getCfg() {
        Slimefun.validateInstance();
        return Slimefun.instance.config;
    }

    @Nonnull
    public static Config getResearchCfg() {
        Slimefun.validateInstance();
        return Slimefun.instance.researches;
    }

    @Nonnull
    public static Config getItemCfg() {
        Slimefun.validateInstance();
        return Slimefun.instance.items;
    }

    @Nonnull
    public static GPSNetwork getGPSNetwork() {
        Slimefun.validateInstance();
        return Slimefun.instance.gpsNetwork;
    }

    @Nonnull
    public static TickerTask getTickerTask() {
        Slimefun.validateInstance();
        return Slimefun.instance.ticker;
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        Slimefun.validateInstance();
        return Slimefun.instance.local;
    }

    @Nonnull
    public static MinecraftRecipeService getMinecraftRecipeService() {
        Slimefun.validateInstance();
        return Slimefun.instance.recipeService;
    }

    @Nonnull
    public static CustomItemDataService getItemDataService() {
        Slimefun.validateInstance();
        return Slimefun.instance.itemDataService;
    }

    @Nonnull
    public static CustomTextureService getItemTextureService() {
        Slimefun.validateInstance();
        return Slimefun.instance.textureService;
    }

    @Nonnull
    public static PermissionsService getPermissionsService() {
        Slimefun.validateInstance();
        return Slimefun.instance.permissionsService;
    }

    @Nonnull
    public static BlockDataService getBlockDataService() {
        Slimefun.validateInstance();
        return Slimefun.instance.blockDataService;
    }

    @Nonnull
    public static PerWorldSettingsService getWorldSettingsService() {
        Slimefun.validateInstance();
        return Slimefun.instance.worldSettingsService;
    }

    @Nonnull
    public static HologramsService getHologramsService() {
        Slimefun.validateInstance();
        return Slimefun.instance.hologramsService;
    }

    @Nonnull
    public static SoundService getSoundService() {
        Slimefun.validateInstance();
        return Slimefun.instance.soundService;
    }

    @Nonnull
    public static IntegrationsManager getIntegrations() {
        Slimefun.validateInstance();
        return Slimefun.instance.integrations;
    }

    @Nonnull
    public static ProtectionManager getProtectionManager() {
        return Slimefun.getIntegrations().getProtectionManager();
    }

    @Nonnull
    public static UpdaterService getUpdater() {
        Slimefun.validateInstance();
        return Slimefun.instance.updaterService;
    }

    @Nonnull
    public static MetricsService getMetricsService() {
        Slimefun.validateInstance();
        return Slimefun.instance.metricsService;
    }

    @Nonnull
    public static GitHubService getGitHubService() {
        Slimefun.validateInstance();
        return Slimefun.instance.gitHubService;
    }

    @Nonnull
    public static NetworkManager getNetworkManager() {
        Slimefun.validateInstance();
        return Slimefun.instance.networkManager;
    }

    @Nonnull
    public static SlimefunRegistry getRegistry() {
        Slimefun.validateInstance();
        return Slimefun.instance.registry;
    }

    @Nonnull
    public static GrapplingHookListener getGrapplingHookListener() {
        Slimefun.validateInstance();
        return Slimefun.instance.grapplingHookListener;
    }

    @Nonnull
    public static BackpackListener getBackpackListener() {
        Slimefun.validateInstance();
        return Slimefun.instance.backpackListener;
    }

    @Nonnull
    public static SlimefunBowListener getBowListener() {
        Slimefun.validateInstance();
        return Slimefun.instance.bowListener;
    }

    @Nonnull
    public static SlimefunCommand getCommand() {
        Slimefun.validateInstance();
        return Slimefun.instance.command;
    }

    @Nonnull
    public static SlimefunProfiler getProfiler() {
        Slimefun.validateInstance();
        return Slimefun.instance.profiler;
    }

    @Nonnull
    public static MinecraftVersion getMinecraftVersion() {
        Slimefun.validateInstance();
        return Slimefun.instance.minecraftVersion;
    }

    public static boolean isNewlyInstalled() {
        Slimefun.validateInstance();
        return Slimefun.instance.isNewlyInstalled;
    }

    @Nonnull
    public static Set<Plugin> getInstalledAddons() {
        Slimefun.validateInstance();
        String pluginName = instance.getName();
        return Arrays.stream(instance.getServer().getPluginManager().getPlugins()).filter(plugin -> {
            PluginDescriptionFile description = plugin.getDescription();
            return description.getDepend().contains(pluginName) || description.getSoftDepend().contains(pluginName);
        }).collect(Collectors.toSet());
    }

    @Nullable
    public static BukkitTask runSync(@Nonnull Runnable runnable, long delay) {
        Validate.notNull(runnable, "Cannot run null");
        Validate.isTrue(delay >= 0L, "The delay cannot be negative");
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            runnable.run();
            return null;
        }
        if (instance == null || !instance.isEnabled()) {
            return null;
        }
        return instance.getServer().getScheduler().runTaskLater((Plugin)instance, runnable, delay);
    }

    @Nullable
    public static BukkitTask runSync(@Nonnull Runnable runnable) {
        Validate.notNull(runnable, "Cannot run null");
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            runnable.run();
            return null;
        }
        if (instance == null || !instance.isEnabled()) {
            return null;
        }
        return instance.getServer().getScheduler().runTask((Plugin)instance, runnable);
    }

    @Nonnull
    public static Storage getPlayerStorage() {
        return Slimefun.instance().playerStorage;
    }
}

