/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.thebusybiscuit.slimefun4.api.events.AsyncProfileLoadEvent;
import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.items.HashedArmorpiece;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectiveArmor;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.SlimefunArmorPiece;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.storage.data.PlayerData;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerProfile {
    private final UUID ownerId;
    private final String name;
    private final Config configFile;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private final GuideHistory guideHistory = new GuideHistory(this);
    private final HashedArmorpiece[] armor = new HashedArmorpiece[]{new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece()};
    private final PlayerData data;

    protected PlayerProfile(@Nonnull OfflinePlayer p, PlayerData data) {
        this.ownerId = p.getUniqueId();
        this.name = p.getName();
        this.data = data;
        this.configFile = new Config("data-storage/Slimefun/Players/" + this.ownerId.toString() + ".yml");
    }

    @Nonnull
    public HashedArmorpiece[] getArmor() {
        return this.armor;
    }

    @Deprecated
    @Nonnull
    public Config getConfig() {
        return this.configFile;
    }

    @Nonnull
    public UUID getUUID() {
        return this.ownerId;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        Slimefun.getPlayerStorage().savePlayerData(this.ownerId, this.data);
        this.dirty = false;
    }

    public void setResearched(@Nonnull Research research, boolean unlock) {
        Validate.notNull(research, "Research must not be null!");
        this.dirty = true;
        if (unlock) {
            this.data.addResearch(research);
        } else {
            this.data.removeResearch(research);
        }
    }

    public boolean hasUnlocked(@Nullable Research research) {
        if (research == null) {
            return true;
        }
        return !research.isEnabled() || this.data.getResearches().contains(research);
    }

    public boolean hasUnlockedEverything() {
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (this.hasUnlocked(research)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<Research> getResearches() {
        return ImmutableSet.copyOf(this.data.getResearches());
    }

    @Nonnull
    public List<Waypoint> getWaypoints() {
        return ImmutableList.copyOf(this.data.getWaypoints());
    }

    public void addWaypoint(@Nonnull Waypoint waypoint) {
        this.data.addWaypoint(waypoint);
        this.markDirty();
    }

    public void removeWaypoint(@Nonnull Waypoint waypoint) {
        this.data.removeWaypoint(waypoint);
        this.markDirty();
    }

    public final void markForDeletion() {
        this.markedForDeletion = true;
    }

    public final void markDirty() {
        this.dirty = true;
    }

    @Nonnull
    public PlayerBackpack createBackpack(int size) {
        int nextId = this.data.getBackpacks().size();
        PlayerBackpack backpack = PlayerBackpack.newBackpack(this.ownerId, nextId, size);
        this.data.addBackpack(backpack);
        this.markDirty();
        return backpack;
    }

    @Nonnull
    public Optional<PlayerBackpack> getBackpack(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Backpacks cannot have negative ids!");
        }
        PlayerBackpack backpack = this.data.getBackpack(id);
        if (backpack != null) {
            this.markDirty();
            return Optional.of(backpack);
        }
        return Optional.empty();
    }

    private int countNonEmptyResearches(@Nonnull Collection<Research> researches) {
        int count = 0;
        for (Research research : researches) {
            if (!research.hasEnabledItems()) continue;
            ++count;
        }
        return count;
    }

    @Nonnull
    public String getTitle() {
        List<String> titles = Slimefun.getRegistry().getResearchRanks();
        int allResearches = this.countNonEmptyResearches(Slimefun.getRegistry().getResearches());
        float fraction = (float)this.countNonEmptyResearches(this.getResearches()) / (float)allResearches;
        int index = (int)(fraction * (float)(titles.size() - 1));
        return titles.get(index);
    }

    public void sendStats(@Nonnull CommandSender sender) {
        int unlockedResearches = this.countNonEmptyResearches(this.getResearches());
        int levels = this.getResearches().stream().mapToInt(Research::getCost).sum();
        int allResearches = this.countNonEmptyResearches(Slimefun.getRegistry().getResearches());
        float progress = (float)Math.round((float)unlockedResearches * 100.0f / (float)allResearches * 100.0f) / 100.0f;
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Statistics for Player: &b" + this.name));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Title: " + ChatColor.AQUA + this.getTitle()));
        sender.sendMessage(ChatColors.color("&7Research Progress: " + NumberUtils.getColorFromPercentage(progress) + progress + " &r% " + ChatColor.YELLOW + "(" + unlockedResearches + " / " + allResearches + ")"));
        sender.sendMessage(ChatColors.color("&7Total XP Levels spent: " + ChatColor.AQUA + levels));
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    @Nonnull
    public GuideHistory getGuideHistory() {
        return this.guideHistory;
    }

    public static boolean fromUUID(@Nonnull UUID uuid, @Nonnull Consumer<PlayerProfile> callback) {
        return PlayerProfile.get(Bukkit.getOfflinePlayer((UUID)uuid), callback);
    }

    public static boolean get(@Nonnull OfflinePlayer p, @Nonnull Consumer<PlayerProfile> callback) {
        Validate.notNull(p, "Cannot get a PlayerProfile for: null!");
        UUID uuid = p.getUniqueId();
        PlayerProfile profile = Slimefun.getRegistry().getPlayerProfiles().get(uuid);
        if (profile != null) {
            callback.accept(profile);
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Slimefun.instance(), () -> {
            PlayerData data = Slimefun.getPlayerStorage().loadPlayerData(p.getUniqueId());
            AsyncProfileLoadEvent event = new AsyncProfileLoadEvent(new PlayerProfile(p, data));
            Bukkit.getPluginManager().callEvent((Event)event);
            Slimefun.getRegistry().getPlayerProfiles().put(uuid, event.getProfile());
            callback.accept(event.getProfile());
        });
        return false;
    }

    public static boolean request(@Nonnull OfflinePlayer p) {
        Validate.notNull(p, "Cannot request a Profile for null");
        if (!Slimefun.getRegistry().getPlayerProfiles().containsKey(p.getUniqueId())) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Slimefun.instance(), () -> {
                PlayerData data = Slimefun.getPlayerStorage().loadPlayerData(p.getUniqueId());
                PlayerProfile pp = new PlayerProfile(p, data);
                Slimefun.getRegistry().getPlayerProfiles().put(p.getUniqueId(), pp);
            });
            return false;
        }
        return true;
    }

    @Nonnull
    public static Optional<PlayerProfile> find(@Nonnull OfflinePlayer p) {
        return Optional.ofNullable(Slimefun.getRegistry().getPlayerProfiles().get(p.getUniqueId()));
    }

    @Nonnull
    public static Iterator<PlayerProfile> iterator() {
        return Slimefun.getRegistry().getPlayerProfiles().values().iterator();
    }

    public static void getBackpack(@Nullable ItemStack item, @Nonnull Consumer<PlayerBackpack> callback) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return;
        }
        OptionalInt id = OptionalInt.empty();
        String uuid = "";
        for (String line : item.getItemMeta().getLore()) {
            String[] splitLine;
            if (!line.startsWith(ChatColors.color("&7ID: ")) || line.indexOf(35) == -1 || !CommonPatterns.NUMERIC.matcher((splitLine = CommonPatterns.HASH.split(line))[1]).matches()) continue;
            id = OptionalInt.of(Integer.parseInt(splitLine[1]));
            uuid = splitLine[0].replace(ChatColors.color("&7ID: "), "");
        }
        if (id.isPresent()) {
            int number = id.getAsInt();
            PlayerProfile.fromUUID(UUID.fromString(uuid), profile -> {
                Optional<PlayerBackpack> backpack = profile.getBackpack(number);
                backpack.ifPresent(callback);
            });
        }
    }

    public boolean hasFullProtectionAgainst(@Nonnull ProtectionType type) {
        Validate.notNull((Object)type, "ProtectionType must not be null.");
        int armorCount = 0;
        NamespacedKey setId = null;
        for (HashedArmorpiece armorpiece : this.armor) {
            ProtectionType[] protectionTypeArray;
            Optional<SlimefunArmorPiece> armorPiece = armorpiece.getItem();
            if (!armorPiece.isPresent() || !((protectionTypeArray = armorPiece.get()) instanceof ProtectiveArmor)) continue;
            ProtectiveArmor protectiveArmor = (ProtectiveArmor)protectionTypeArray;
            protectionTypeArray = protectiveArmor.getProtectionTypes();
            int n = protectionTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ProtectionType protectionType = protectionTypeArray[i];
                if (protectionType != type) continue;
                if (!protectiveArmor.isFullSetRequired()) {
                    return true;
                }
                if (setId != null && !setId.equals((Object)protectiveArmor.getArmorSetId())) continue;
                ++armorCount;
                setId = protectiveArmor.getArmorSetId();
            }
        }
        return armorCount == 4;
    }

    public PlayerData getPlayerData() {
        return this.data;
    }

    public int hashCode() {
        return this.ownerId.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerProfile)) return false;
        PlayerProfile profile = (PlayerProfile)obj;
        if (!this.ownerId.equals(profile.ownerId)) return false;
        return true;
    }

    public String toString() {
        return "PlayerProfile {" + this.ownerId + "}";
    }
}

