/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.geo;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.GEOMiningOperation;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GEOMiner
extends SlimefunItem
implements RecipeDisplayItem,
EnergyNetComponent,
InventoryBlock,
HologramOwner,
MachineProcessHolder<GEOMiningOperation> {
    private static final int[] BORDER = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 53};
    private static final int[] OUTPUT_BORDER = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 34, 37, 43, 46, 47, 48, 49, 50, 51, 52};
    private static final int[] OUTPUT_SLOTS = new int[]{29, 30, 31, 32, 33, 38, 39, 40, 41, 42};
    private static final int PROCESSING_TIME = 14;
    private final MachineProcessor<GEOMiningOperation> processor = new MachineProcessor<GEOMiningOperation>(this);
    private int energyConsumedPerTick = -1;
    private int energyCapacity = -1;
    private int processingSpeed = -1;

    @ParametersAreNonnullByDefault
    public GEOMiner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.processor.setProgressBar(new ItemStack(Material.DIAMOND_PICKAXE));
        this.createPreset(this, this.getItemName(), this::constructMenu);
        this.addItemHandler(this.onBlockPlace(), this.onBlockBreak());
    }

    @Override
    @Nonnull
    public MachineProcessor<GEOMiningOperation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    public int getCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public int getSpeed() {
        return this.processingSpeed;
    }

    public final GEOMiner setCapacity(int capacity) {
        Validate.isTrue(capacity > 0, "The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public final GEOMiner setProcessingSpeed(int speed) {
        Validate.isTrue(speed > 0, "The speed must be greater than zero!");
        this.processingSpeed = speed;
        return this;
    }

    public final GEOMiner setEnergyConsumption(int energyConsumption) {
        Validate.isTrue(energyConsumption > 0, "The energy consumption must be greater than zero!");
        Validate.isTrue(this.energyCapacity > 0, "You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue(energyConsumption <= this.energyCapacity, "The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ")");
        this.energyConsumedPerTick = energyConsumption;
        return this;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        this.addon = addon;
        if (this.getCapacity() <= 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyConsumption() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyConsumption(...)' before registering!");
        }
        if (this.getSpeed() <= 0) {
            this.warn("The processing speed has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setProcessingSpeed(...)' before registering!");
        }
        if (this.getCapacity() > 0 && this.getEnergyConsumption() > 0 && this.getSpeed() > 0) {
            super.register(addon);
        }
    }

    @Nonnull
    private BlockPlaceHandler onBlockPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                GEOMiner.this.updateHologram(e.getBlock(), "&7Idling...");
            }
        };
    }

    @Nonnull
    private BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            @Override
            public void onBlockBreak(@Nonnull Block b) {
                GEOMiner.this.removeHologram(b);
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), OUTPUT_SLOTS);
                }
                GEOMiner.this.processor.endOperation(b);
            }
        };
    }

    @Override
    @Nonnull
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    @Nonnull
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        LinkedList<ItemStack> displayRecipes = new LinkedList<ItemStack>();
        for (GEOResource resource : Slimefun.getRegistry().getGEOResources().values()) {
            if (!resource.isObtainableFromGEOMiner()) continue;
            displayRecipes.add(new CustomItemStack(resource.getItem(), ChatColor.RESET + resource.getName(), new String[0]));
        }
        return displayRecipes;
    }

    @Override
    @Nonnull
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.miner";
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    protected void constructMenu(@Nonnull BlockMenuPreset preset) {
        for (int i : BORDER) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, ChestMenuUtils.getOutputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(4, new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : OUTPUT_SLOTS) {
            preset.addMenuClickHandler(i, new ChestMenu.AdvancedMenuClickHandler(){

                @Override
                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                @Override
                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                GEOMiner.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        });
    }

    protected void tick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        GEOMiningOperation operation = this.processor.getOperation(b);
        if (operation != null) {
            if (!operation.isFinished()) {
                this.processor.updateProgressBar(inv, 4, operation);
                if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                    return;
                }
                this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                operation.addProgress(this.getSpeed());
            } else {
                inv.replaceExistingItem(4, new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                inv.pushItem(operation.getResult(), OUTPUT_SLOTS);
                this.processor.endOperation(b);
            }
        } else if (!BlockStorage.hasChunkInfo(b.getWorld(), b.getX() >> 4, b.getZ() >> 4)) {
            this.updateHologram(b, "&4GEO-Scan required!");
        } else {
            this.start(b, inv);
        }
    }

    private void start(@Nonnull Block b, @Nonnull BlockMenu inv) {
        for (GEOResource resource : Slimefun.getRegistry().getGEOResources().values()) {
            if (!resource.isObtainableFromGEOMiner()) continue;
            OptionalInt optional = Slimefun.getGPSNetwork().getResourceManager().getSupplies(resource, b.getWorld(), b.getX() >> 4, b.getZ() >> 4);
            if (!optional.isPresent()) {
                this.updateHologram(b, "&4GEO-Scan required!");
                return;
            }
            int supplies = optional.getAsInt();
            if (supplies <= 0) continue;
            if (!inv.fits(resource.getItem(), OUTPUT_SLOTS)) {
                return;
            }
            this.processor.startOperation(b, new GEOMiningOperation(resource, 14));
            Slimefun.getGPSNetwork().getResourceManager().setSupplies(resource, b.getWorld(), b.getX() >> 4, b.getZ() >> 4, supplies - 1);
            this.updateHologram(b, "&7Mining: &r" + resource.getName());
            return;
        }
        this.updateHologram(b, "&7Finished");
    }
}

