/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.events.ExplosiveToolBreakBlocksEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockBreakEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private static final BlockFace[] CARDINAL_BLOCKFACES = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN, BlockFace.UP};

    public BlockListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPlaceExisting(BlockPlaceEvent e) {
        Block block = e.getBlock();
        if (e.getBlockReplacedState().getType().isAir()) {
            SlimefunItem sfItem = BlockStorage.check(block);
            if (sfItem != null && !Slimefun.getTickerTask().isDeletedSoon(block.getLocation())) {
                for (ItemStack item : sfItem.getDrops()) {
                    if (item == null || item.getType().isAir()) continue;
                    block.getWorld().dropItemNaturally(block.getLocation(), item);
                }
                BlockStorage.clearBlockInfo(block);
            }
        } else if (BlockStorage.hasBlockInfo(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        ItemStack item = e.getItemInHand();
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (!Slimefun.instance().isUnitTest()) {
            Slimefun.getProtectionManager().logAction((OfflinePlayer)e.getPlayer(), e.getBlock(), Interaction.PLACE_BLOCK);
        }
        if (sfItem != null && !(sfItem instanceof NotPlaceable)) {
            Player player = e.getPlayer();
            if (!sfItem.canUse(player, true)) {
                e.setCancelled(true);
            } else {
                Block block = e.getBlockPlaced();
                if (Slimefun.getTickerTask().isDeletedSoon(block.getLocation())) {
                    Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.await-deletion");
                    e.setCancelled(true);
                    return;
                }
                SlimefunBlockPlaceEvent placeEvent = new SlimefunBlockPlaceEvent(player, item, block, sfItem);
                Bukkit.getPluginManager().callEvent((Event)placeEvent);
                if (placeEvent.isCancelled()) {
                    e.setCancelled(true);
                } else {
                    if (Slimefun.getBlockDataService().isTileEntity(block.getType())) {
                        Slimefun.getBlockDataService().setBlockData(block, sfItem.getId());
                    }
                    BlockStorage.addBlockInfo(block, "id", sfItem.getId(), true);
                    sfItem.callItemHandler(BlockPlaceHandler.class, handler -> handler.onPlayerPlace(e));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (Slimefun.getIntegrations().isEventFaked((Event)e)) {
            return;
        }
        if (Slimefun.getIntegrations().isCustomBlock(e.getBlock())) {
            return;
        }
        if (Slimefun.getTickerTask().isDeletedSoon(e.getBlock().getLocation())) {
            return;
        }
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        SlimefunItem sfItem = BlockStorage.check(e.getBlock());
        if (sfItem != null) {
            SlimefunBlockBreakEvent breakEvent = new SlimefunBlockBreakEvent(e.getPlayer(), item, e.getBlock(), sfItem);
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (breakEvent.isCancelled()) {
                e.setCancelled(true);
                return;
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!item.getType().isAir()) {
            int fortune = this.getBonusDropsWithFortune(item, e.getBlock());
            this.callToolHandler(e, item, fortune, drops);
        }
        if (!e.isCancelled()) {
            this.checkForSensitiveBlockAbove(e.getPlayer(), e.getBlock(), item);
            this.callBlockHandler(e, item, drops, sfItem);
            this.dropItems(e, drops);
            this.checkForSensitiveBlocks(e.getBlock(), 0, e.isDropItems());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExplosiveToolBlockBreak(ExplosiveToolBreakBlocksEvent e) {
        for (Block block : e.getAdditionalBlocks()) {
            this.checkForSensitiveBlockAbove(e.getPlayer(), block, e.getItemInHand());
        }
    }

    @ParametersAreNonnullByDefault
    private void callToolHandler(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
        SlimefunItem tool = SlimefunItem.getByItem(item);
        if (tool != null) {
            if (tool.canUse(e.getPlayer(), true)) {
                tool.callItemHandler(ToolUseHandler.class, handler -> handler.onToolUse(e, item, fortune, drops));
            } else {
                e.setCancelled(true);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void callBlockHandler(BlockBreakEvent e, ItemStack item, List<ItemStack> drops, @Nullable SlimefunItem sfItem) {
        Optional<String> blockData;
        if (sfItem == null && Slimefun.getBlockDataService().isTileEntity(e.getBlock().getType()) && (blockData = Slimefun.getBlockDataService().getBlockData(e.getBlock())).isPresent()) {
            sfItem = SlimefunItem.getById(blockData.get());
        }
        if (sfItem != null && !sfItem.useVanillaBlockBreaking()) {
            sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onPlayerBreak(e, item, drops));
            if (e.isCancelled()) {
                return;
            }
            drops.addAll(sfItem.getDrops());
            BlockStorage.clearBlockInfo(e.getBlock());
        }
    }

    @ParametersAreNonnullByDefault
    private void dropItems(BlockBreakEvent e, List<ItemStack> drops) {
        if (!drops.isEmpty()) {
            if (!Slimefun.instance().isUnitTest()) {
                Slimefun.getProtectionManager().logAction((OfflinePlayer)e.getPlayer(), e.getBlock(), Interaction.BREAK_BLOCK);
            }
            if (e.isDropItems()) {
                e.setDropItems(false);
                for (ItemStack drop : drops) {
                    if (drop == null || drop.getType() == Material.AIR || e.getPlayer().getGameMode() == GameMode.CREATIVE && !Slimefun.getCfg().getBoolean("options.drop-block-creative")) continue;
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void checkForSensitiveBlockAbove(Player player, Block block, ItemStack item) {
        SlimefunItem sfItem;
        Block blockAbove = block.getRelative(BlockFace.UP);
        if (SlimefunTag.SENSITIVE_MATERIALS.isTagged(blockAbove.getType()) && (sfItem = BlockStorage.check(blockAbove)) != null && !sfItem.useVanillaBlockBreaking()) {
            BlockBreakEvent dummyEvent = new BlockBreakEvent(blockAbove, player);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(sfItem.getDrops(player));
            sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onPlayerBreak(dummyEvent, item, drops));
            blockAbove.setType(Material.AIR);
            if (!dummyEvent.isCancelled() && dummyEvent.isDropItems()) {
                for (ItemStack drop : drops) {
                    if (drop == null || drop.getType().isAir()) continue;
                    blockAbove.getWorld().dropItemNaturally(blockAbove.getLocation(), drop);
                }
            }
            BlockStorage.clearBlockInfo(blockAbove);
        }
    }

    @ParametersAreNonnullByDefault
    private void checkForSensitiveBlocks(Block block, Integer count, boolean isDropItems) {
        if (count >= Bukkit.getServer().getMaxChainedNeighborUpdates()) {
            return;
        }
        BlockState state = block.getState();
        block.setType(Material.AIR, false);
        for (BlockFace face : CARDINAL_BLOCKFACES) {
            if (this.isSupported(block.getRelative(face).getBlockData(), block.getRelative(face))) continue;
            Block relative = block.getRelative(face);
            if (!isDropItems) {
                for (ItemStack drop : relative.getDrops()) {
                    block.getWorld().dropItemNaturally(relative.getLocation(), drop);
                }
            }
            count = count + 1;
            this.checkForSensitiveBlocks(relative, count, isDropItems);
        }
        block.setBlockData(state.getBlockData(), false);
        state.update(true, false);
    }

    @ParametersAreNonnullByDefault
    private boolean isSupported(BlockData blockData, Block block) {
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_19)) {
            return blockData.isSupported(block);
        }
        return true;
    }

    private int getBonusDropsWithFortune(@Nullable ItemStack item, @Nonnull Block b) {
        ItemMeta meta;
        int fortuneLevel;
        int amount = 1;
        if (item != null && !item.getType().isAir() && item.hasItemMeta() && (fortuneLevel = (meta = item.getItemMeta()).getEnchantLevel(Enchantment.LOOT_BONUS_BLOCKS)) > 0 && !meta.hasEnchant(Enchantment.SILK_TOUCH)) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            amount = Math.max(1, ((Random)random).nextInt(fortuneLevel + 2) - 1);
            amount = (b.getType() == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (amount + 1);
        }
        return amount;
    }
}

