/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.versions;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.AbstractNumericVersion;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.Version;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PrefixedVersion
extends AbstractNumericVersion {
    private final String prefix;

    public PrefixedVersion(@Nonnull String prefix, int version) {
        super(version);
        Validate.notNull(prefix, "The prefix cannot be null.");
        this.prefix = prefix;
    }

    @Override
    public boolean isSimilar(@Nonnull Version version) {
        return version instanceof PrefixedVersion && this.prefix.equals(((PrefixedVersion)version).getPrefix());
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.prefix + this.getVersionNumber();
    }

    @Nonnull
    public final String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.getVersionNumber());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version && this.isSimilar((Version)obj)) {
            return this.isEqualTo((Version)obj);
        }
        return false;
    }

    public String toString() {
        return "PrefixedVersion [" + this.getAsString() + "]";
    }
}

