/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.DefaultInterceptor;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequestSummary;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Interceptor;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

class CompoundInterceptor
implements Interceptor {
    private List<Interceptor> interceptors;

    CompoundInterceptor() {
        this(Collections.singletonList(new DefaultInterceptor()));
    }

    CompoundInterceptor(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void onRequest(HttpRequest<?> request, Config config) {
        this.interceptors.forEach(i -> i.onRequest(request, config));
    }

    @Override
    public void onResponse(HttpResponse<?> response, HttpRequestSummary request, Config config) {
        this.interceptors.forEach(i -> i.onResponse(response, request, config));
    }

    @Override
    public HttpResponse<?> onFail(Exception e, HttpRequestSummary request, Config config) throws UnirestException {
        return (HttpResponse)this.interceptors.stream().map(i -> Optional.ofNullable(i.onFail(e, request, config))).flatMap(Util::stream).findFirst().orElseThrow(() -> new UnirestException(e));
    }

    int size() {
        return this.interceptors.size();
    }

    List<Interceptor> getInterceptors() {
        return new ArrayList<Interceptor>(this.interceptors);
    }

    void register(Interceptor t1) {
        if (this.interceptors.stream().anyMatch(i -> i instanceof DefaultInterceptor)) {
            this.interceptors = new ArrayList<Interceptor>();
        }
        if (!this.interceptors.contains(t1)) {
            this.interceptors.add(t1);
        }
    }
}

