/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

abstract class AbstractCraftingTable
extends MultiBlockMachine {
    @ParametersAreNonnullByDefault
    AbstractCraftingTable(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, BlockFace trigger) {
        super(itemGroup, item, recipe, trigger);
    }

    @Nonnull
    protected Inventory createVirtualInventory(@Nonnull Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (String)"Fake Inventory");
        for (int j = 0; j < inv.getContents().length; ++j) {
            ItemStack stack = inv.getContents()[j];
            if (stack != null) {
                stack = stack.clone();
                ItemUtils.consumeItem(stack, true);
            }
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }

    @ParametersAreNonnullByDefault
    protected void upgradeBackpack(Player p, Inventory inv, SlimefunBackpack backpack, ItemStack output) {
        int size;
        Optional<String> id;
        ItemStack input = null;
        for (int j = 0; j < 9; ++j) {
            if (inv.getContents()[j] == null || inv.getContents()[j].getType() == Material.AIR || !(SlimefunItem.getByItem(inv.getContents()[j]) instanceof SlimefunBackpack)) continue;
            input = inv.getContents()[j];
            break;
        }
        if (SlimefunUtils.isSoulbound(input)) {
            SlimefunUtils.setSoulbound(output, true);
        }
        if ((id = this.retrieveID(input, size = backpack.getSize())).isPresent()) {
            for (int line = 0; line < output.getItemMeta().getLore().size(); ++line) {
                if (!((String)output.getItemMeta().getLore().get(line)).equals(ChatColors.color("&7ID: <ID>"))) continue;
                ItemMeta im = output.getItemMeta();
                List lore = im.getLore();
                lore.set(line, ((String)lore.get(line)).replace("<ID>", id.get()));
                im.setLore(lore);
                output.setItemMeta(im);
                break;
            }
        } else {
            for (int line = 0; line < output.getItemMeta().getLore().size(); ++line) {
                if (!((String)output.getItemMeta().getLore().get(line)).equals(ChatColors.color("&7ID: <ID>"))) continue;
                int target = line;
                PlayerProfile.get((OfflinePlayer)p, profile -> {
                    int backpackId = profile.createBackpack(size).getId();
                    Slimefun.getBackpackListener().setBackpackId((OfflinePlayer)p, output, target, backpackId);
                });
                break;
            }
        }
    }

    @Nonnull
    private Optional<String> retrieveID(@Nullable ItemStack backpack, int size) {
        if (backpack != null) {
            for (String line : backpack.getItemMeta().getLore()) {
                if (!line.startsWith(ChatColors.color("&7ID: ")) || !line.contains("#")) continue;
                String id = line.replace(ChatColors.color("&7ID: "), "");
                String[] idSplit = CommonPatterns.HASH.split(id);
                PlayerProfile.fromUUID(UUID.fromString(idSplit[0]), profile -> {
                    Optional<PlayerBackpack> optional = profile.getBackpack(Integer.parseInt(idSplit[1]));
                    optional.ifPresent(playerBackpack -> {
                        CompletableFuture<Void> future = playerBackpack.closeForAll();
                        future.thenRun(() -> playerBackpack.setSize(size));
                    });
                });
                return Optional.of(id);
            }
        }
        return Optional.empty();
    }
}

