/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.updater;

import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.PluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdateInfo;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.Version;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

abstract class UpdaterTask<V extends Version>
implements Runnable {
    private final Plugin plugin;
    private final File file;
    private final URL url;
    private final int timeout;
    private final V currentVersion;

    UpdaterTask(@Nonnull PluginUpdater<V> updater, @Nonnull URL url) {
        this.plugin = updater.getPlugin();
        this.file = updater.getFile();
        this.url = url;
        this.timeout = updater.getConnectionTimeout();
        this.currentVersion = updater.getCurrentVersion();
    }

    @Nullable
    public abstract UpdateInfo parse(String var1) throws MalformedURLException, URISyntaxException;

    @Override
    public void run() {
        try {
            UpdateInfo latestVersion = this.getLatestVersion(this.url);
            if (latestVersion != null) {
                this.validateAndInstall(latestVersion);
            }
        }
        catch (NumberFormatException x) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update {0}", this.plugin.getName());
            this.plugin.getLogger().log(Level.SEVERE, "Unrecognized Version: {0}", this.currentVersion);
        }
    }

    @Nullable
    private UpdateInfo getLatestVersion(@Nonnull URL url) {
        UpdateInfo updateInfo;
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(this.timeout);
        connection.addRequestProperty("User-Agent", "Auto Updater (by TheBusyBiscuit)");
        connection.setDoOutput(true);
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            updateInfo = this.parse(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not connect to the updating site, is it down?", e);
                return null;
            }
        }
        reader.close();
        return updateInfo;
    }

    private void validateAndInstall(@Nonnull UpdateInfo updateInfo) {
        if (updateInfo.getVersion().isNewerThan((Version)this.currentVersion)) {
            this.install(updateInfo);
        } else {
            this.plugin.getLogger().log(Level.INFO, "{0} is already up to date!", this.plugin.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(@Nonnull UpdateInfo info) {
        this.plugin.getLogger().log(Level.INFO, "{0} is outdated!", this.plugin.getName());
        this.plugin.getLogger().log(Level.INFO, "Downloading {0}, version: {1}", new Object[]{this.plugin.getName(), info.getVersion()});
        try {
            try (BufferedInputStream input = new BufferedInputStream(info.getUrl().openStream());
                 FileOutputStream output = new FileOutputStream(new File("plugins/" + Bukkit.getUpdateFolder(), this.file.getName()));){
                int read;
                byte[] data = new byte[1024];
                while ((read = input.read(data, 0, 1024)) != -1) {
                    output.write(data, 0, read);
                }
            }
            this.plugin.getLogger().log(Level.INFO, " ");
            this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
        }
        catch (Exception x) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, x, () -> "Failed to auto-update " + this.plugin.getName());
                this.plugin.getLogger().log(Level.INFO, " ");
                this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.INFO, " ");
                this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
                this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.currentVersion, info.getVersion()});
                this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
                this.plugin.getLogger().log(Level.INFO, " ");
                throw throwable;
            }
            this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.currentVersion, info.getVersion()});
            this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
            this.plugin.getLogger().log(Level.INFO, " ");
        }
        this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.currentVersion, info.getVersion()});
        this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
        this.plugin.getLogger().log(Level.INFO, " ");
    }
}

