/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.SlimefunArmorPiece;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.plugin.Plugin;

public class ElytraImpactListener
implements Listener {
    private final Set<UUID> gliding = new HashSet<UUID>();

    public ElytraImpactListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onGlideToggle(EntityToggleGlideEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).isGliding()) {
            UUID uuid = player.getUniqueId();
            this.gliding.add(uuid);
        }
        Slimefun.instance().getServer().getScheduler().runTaskLater((Plugin)Slimefun.instance(), this.gliding::clear, 1L);
    }

    @EventHandler
    public void onPlayerCrash(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if ((e.getCause() == EntityDamageEvent.DamageCause.FALL || e.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && (p.isGliding() || this.gliding.contains(p.getUniqueId()))) {
            SlimefunItem item;
            Optional<PlayerProfile> optional = PlayerProfile.find((OfflinePlayer)p);
            if (optional.isEmpty()) {
                PlayerProfile.request((OfflinePlayer)p);
                return;
            }
            PlayerProfile profile = optional.get();
            Optional<SlimefunArmorPiece> helmet = profile.getArmor()[3].getItem();
            if (helmet.isPresent() && (item = (SlimefunItem)helmet.get()).canUse(p, true) && profile.hasFullProtectionAgainst(ProtectionType.FLYING_INTO_WALL)) {
                SoundEffect.ELYTRA_CAP_IMPACT_SOUND.playFor(p);
                e.setCancelled(true);
                if (item instanceof DamageableItem) {
                    DamageableItem damageableItem = (DamageableItem)((Object)item);
                    damageableItem.damageItem(p, p.getInventory().getHelmet());
                }
            }
        }
    }
}

