/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.thebusybiscuit.slimefun4.api.events.AsyncProfileLoadEvent;
import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.items.HashedArmorpiece;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectiveArmor;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.SlimefunArmorPiece;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerProfile {
    private final UUID uuid;
    private final String name;
    private final Config configFile;
    private final Config waypointsFile;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private final Set<Research> researches = new HashSet<Research>();
    private final List<Waypoint> waypoints = new ArrayList<Waypoint>();
    private final Map<Integer, PlayerBackpack> backpacks = new HashMap<Integer, PlayerBackpack>();
    private final GuideHistory guideHistory = new GuideHistory(this);
    private final HashedArmorpiece[] armor = new HashedArmorpiece[]{new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece(), new HashedArmorpiece()};

    protected PlayerProfile(@Nonnull OfflinePlayer p) {
        this.uuid = p.getUniqueId();
        this.name = p.getName();
        this.configFile = new Config("data-storage/Slimefun/Players/" + this.uuid.toString() + ".yml");
        this.waypointsFile = new Config("data-storage/Slimefun/waypoints/" + this.uuid.toString() + ".yml");
        this.loadProfileData();
    }

    private void loadProfileData() {
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (!this.configFile.contains("researches." + research.getID())) continue;
            this.researches.add(research);
        }
        for (String key : this.waypointsFile.getKeys()) {
            try {
                if (!this.waypointsFile.contains(key + ".world") || Bukkit.getWorld((String)this.waypointsFile.getString(key + ".world")) == null) continue;
                String waypointName = this.waypointsFile.getString(key + ".name");
                Location loc = this.waypointsFile.getLocation(key);
                this.waypoints.add(new Waypoint(this, key, loc, waypointName));
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.WARNING, x, () -> "Could not load Waypoint \"" + key + "\" for Player \"" + this.name + "\"");
            }
        }
    }

    @Nonnull
    public HashedArmorpiece[] getArmor() {
        return this.armor;
    }

    @Nonnull
    public Config getConfig() {
        return this.configFile;
    }

    @Nonnull
    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        for (PlayerBackpack backpack : this.backpacks.values()) {
            backpack.save();
        }
        this.waypointsFile.save();
        this.configFile.save();
        this.dirty = false;
    }

    public void setResearched(@Nonnull Research research, boolean unlock) {
        Validate.notNull(research, "Research must not be null!");
        this.dirty = true;
        if (unlock) {
            this.configFile.setValue("researches." + research.getID(), true);
            this.researches.add(research);
        } else {
            this.configFile.setValue("researches." + research.getID(), null);
            this.researches.remove(research);
        }
    }

    public boolean hasUnlocked(@Nullable Research research) {
        if (research == null) {
            return true;
        }
        return !research.isEnabled() || this.researches.contains(research);
    }

    public boolean hasUnlockedEverything() {
        for (Research research : Slimefun.getRegistry().getResearches()) {
            if (this.hasUnlocked(research)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<Research> getResearches() {
        return ImmutableSet.copyOf(this.researches);
    }

    @Nonnull
    public List<Waypoint> getWaypoints() {
        return ImmutableList.copyOf(this.waypoints);
    }

    public void addWaypoint(@Nonnull Waypoint waypoint) {
        Validate.notNull(waypoint, "Cannot add a 'null' waypoint!");
        for (Waypoint wp : this.waypoints) {
            if (!wp.getId().equals(waypoint.getId())) continue;
            throw new IllegalArgumentException("A Waypoint with that id already exists for this Player");
        }
        if (this.waypoints.size() < 21) {
            this.waypoints.add(waypoint);
            this.waypointsFile.setValue(waypoint.getId(), waypoint.getLocation());
            this.waypointsFile.setValue(waypoint.getId() + ".name", waypoint.getName());
            this.markDirty();
        }
    }

    public void removeWaypoint(@Nonnull Waypoint waypoint) {
        Validate.notNull(waypoint, "Cannot remove a 'null' waypoint!");
        if (this.waypoints.remove(waypoint)) {
            this.waypointsFile.setValue(waypoint.getId(), null);
            this.markDirty();
        }
    }

    public final void markForDeletion() {
        this.markedForDeletion = true;
    }

    public final void markDirty() {
        this.dirty = true;
    }

    @Nonnull
    public PlayerBackpack createBackpack(int size) {
        IntStream stream = IntStream.iterate(0, i -> i + 1).filter(i -> !this.configFile.contains("backpacks." + i + ".size"));
        int id = stream.findFirst().getAsInt();
        PlayerBackpack backpack = new PlayerBackpack(this, id, size);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    @Nonnull
    public Optional<PlayerBackpack> getBackpack(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Backpacks cannot have negative ids!");
        }
        PlayerBackpack backpack = this.backpacks.get(id);
        if (backpack != null) {
            return Optional.of(backpack);
        }
        if (this.configFile.contains("backpacks." + id + ".size")) {
            backpack = new PlayerBackpack(this, id);
            this.backpacks.put(id, backpack);
            return Optional.of(backpack);
        }
        return Optional.empty();
    }

    private int nonEmptyResearches() {
        return (int)Slimefun.getRegistry().getResearches().stream().filter(research -> research.getAffectedItems().stream().anyMatch(item -> item.getState() == ItemState.ENABLED)).count();
    }

    @Nonnull
    public String getTitle() {
        List<String> titles = Slimefun.getRegistry().getResearchRanks();
        float fraction = (float)this.researches.size() / (float)this.nonEmptyResearches();
        int index = (int)(fraction * (float)(titles.size() - 1));
        return titles.get(index);
    }

    public void sendStats(@Nonnull CommandSender sender) {
        Set<Research> unlockedResearches = this.getResearches();
        int levels = unlockedResearches.stream().mapToInt(Research::getCost).sum();
        int allResearches = this.nonEmptyResearches();
        float progress = (float)Math.round((float)unlockedResearches.size() * 100.0f / (float)allResearches * 100.0f) / 100.0f;
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Statistics for Player: &b" + this.name));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&7Title: " + ChatColor.AQUA + this.getTitle()));
        sender.sendMessage(ChatColors.color("&7Research Progress: " + NumberUtils.getColorFromPercentage(progress) + progress + " &r% " + ChatColor.YELLOW + "(" + unlockedResearches.size() + " / " + allResearches + ")"));
        sender.sendMessage(ChatColors.color("&7Total XP Levels spent: " + ChatColor.AQUA + levels));
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    @Nonnull
    public GuideHistory getGuideHistory() {
        return this.guideHistory;
    }

    public static boolean fromUUID(@Nonnull UUID uuid, @Nonnull Consumer<PlayerProfile> callback) {
        return PlayerProfile.get(Bukkit.getOfflinePlayer((UUID)uuid), callback);
    }

    public static boolean get(@Nonnull OfflinePlayer p, @Nonnull Consumer<PlayerProfile> callback) {
        Validate.notNull(p, "Cannot get a PlayerProfile for: null!");
        UUID uuid = p.getUniqueId();
        PlayerProfile profile = Slimefun.getRegistry().getPlayerProfiles().get(uuid);
        if (profile != null) {
            callback.accept(profile);
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Slimefun.instance(), () -> {
            AsyncProfileLoadEvent event = new AsyncProfileLoadEvent(new PlayerProfile(p));
            Bukkit.getPluginManager().callEvent((Event)event);
            Slimefun.getRegistry().getPlayerProfiles().put(uuid, event.getProfile());
            callback.accept(event.getProfile());
        });
        return false;
    }

    public static boolean request(@Nonnull OfflinePlayer p) {
        Validate.notNull(p, "Cannot request a Profile for null");
        if (!Slimefun.getRegistry().getPlayerProfiles().containsKey(p.getUniqueId())) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Slimefun.instance(), () -> {
                PlayerProfile pp = new PlayerProfile(p);
                Slimefun.getRegistry().getPlayerProfiles().put(p.getUniqueId(), pp);
            });
            return false;
        }
        return true;
    }

    @Nonnull
    public static Optional<PlayerProfile> find(@Nonnull OfflinePlayer p) {
        return Optional.ofNullable(Slimefun.getRegistry().getPlayerProfiles().get(p.getUniqueId()));
    }

    @Nonnull
    public static Iterator<PlayerProfile> iterator() {
        return Slimefun.getRegistry().getPlayerProfiles().values().iterator();
    }

    public static void getBackpack(@Nullable ItemStack item, @Nonnull Consumer<PlayerBackpack> callback) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return;
        }
        OptionalInt id = OptionalInt.empty();
        String uuid = "";
        for (String line : item.getItemMeta().getLore()) {
            String[] splitLine;
            if (!line.startsWith(ChatColors.color("&7ID: ")) || line.indexOf(35) == -1 || !CommonPatterns.NUMERIC.matcher((splitLine = CommonPatterns.HASH.split(line))[1]).matches()) continue;
            id = OptionalInt.of(Integer.parseInt(splitLine[1]));
            uuid = splitLine[0].replace(ChatColors.color("&7ID: "), "");
        }
        if (id.isPresent()) {
            int number = id.getAsInt();
            PlayerProfile.fromUUID(UUID.fromString(uuid), profile -> {
                Optional<PlayerBackpack> backpack = profile.getBackpack(number);
                backpack.ifPresent(callback);
            });
        }
    }

    public boolean hasFullProtectionAgainst(@Nonnull ProtectionType type) {
        Validate.notNull((Object)type, "ProtectionType must not be null.");
        int armorCount = 0;
        NamespacedKey setId = null;
        for (HashedArmorpiece armorpiece : this.armor) {
            ProtectionType[] protectionTypeArray;
            Optional<SlimefunArmorPiece> armorPiece = armorpiece.getItem();
            if (!armorPiece.isPresent() || !((protectionTypeArray = armorPiece.get()) instanceof ProtectiveArmor)) continue;
            ProtectiveArmor protectiveArmor = (ProtectiveArmor)protectionTypeArray;
            protectionTypeArray = protectiveArmor.getProtectionTypes();
            int n = protectionTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ProtectionType protectionType = protectionTypeArray[i];
                if (protectionType != type) continue;
                if (!protectiveArmor.isFullSetRequired()) {
                    return true;
                }
                if (setId != null && !setId.equals((Object)protectiveArmor.getArmorSetId())) continue;
                ++armorCount;
                setId = protectiveArmor.getArmorSetId();
            }
        }
        return armorCount == 4;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerProfile)) return false;
        PlayerProfile profile = (PlayerProfile)obj;
        if (!this.uuid.equals(profile.uuid)) return false;
        return true;
    }

    public String toString() {
        return "PlayerProfile {" + this.uuid + "}";
    }
}

