/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.machines;

import io.github.thebusybiscuit.slimefun4.api.events.AsyncMachineOperationFinishEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class MachineProcessor<T extends MachineOperation> {
    private final Map<BlockPosition, T> machines = new ConcurrentHashMap<BlockPosition, T>();
    private final MachineProcessHolder<T> owner;
    private ItemStack progressBar;

    public MachineProcessor(@Nonnull MachineProcessHolder<T> owner) {
        Validate.notNull(owner, "The MachineProcessHolder cannot be null.");
        this.owner = owner;
    }

    @Nonnull
    public MachineProcessHolder<T> getOwner() {
        return this.owner;
    }

    @Nullable
    public ItemStack getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(@Nullable ItemStack progressBar) {
        this.progressBar = progressBar;
    }

    public boolean startOperation(@Nonnull Location loc, @Nonnull T operation) {
        Validate.notNull(loc, "The location must not be null");
        Validate.notNull(operation, "The operation cannot be null");
        return this.startOperation(new BlockPosition(loc), operation);
    }

    public boolean startOperation(@Nonnull Block b, @Nonnull T operation) {
        Validate.notNull(b, "The Block must not be null");
        Validate.notNull(operation, "The machine operation cannot be null");
        return this.startOperation(new BlockPosition(b), operation);
    }

    public boolean startOperation(@Nonnull BlockPosition pos, @Nonnull T operation) {
        Validate.notNull(pos, "The BlockPosition must not be null");
        Validate.notNull(operation, "The machine operation cannot be null");
        return this.machines.putIfAbsent(pos, operation) == null;
    }

    @Nullable
    public T getOperation(@Nonnull Location loc) {
        Validate.notNull(loc, "The location cannot be null");
        return this.getOperation(new BlockPosition(loc));
    }

    @Nullable
    public T getOperation(@Nonnull Block b) {
        Validate.notNull(b, "The Block cannot be null");
        return this.getOperation(new BlockPosition(b));
    }

    @Nullable
    public T getOperation(@Nonnull BlockPosition pos) {
        Validate.notNull(pos, "The BlockPosition must not be null");
        return (T)((MachineOperation)this.machines.get(pos));
    }

    public boolean endOperation(@Nonnull Location loc) {
        Validate.notNull(loc, "The location should not be null");
        return this.endOperation(new BlockPosition(loc));
    }

    public boolean endOperation(@Nonnull Block b) {
        Validate.notNull(b, "The Block should not be null");
        return this.endOperation(new BlockPosition(b));
    }

    public boolean endOperation(@Nonnull BlockPosition pos) {
        Validate.notNull(pos, "The BlockPosition cannot be null");
        MachineOperation operation = (MachineOperation)this.machines.remove(pos);
        if (operation != null) {
            if (operation.isFinished()) {
                AsyncMachineOperationFinishEvent event = new AsyncMachineOperationFinishEvent(pos, this, operation);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            return true;
        }
        return false;
    }

    public void updateProgressBar(@Nonnull BlockMenu inv, int slot, @Nonnull T operation) {
        Validate.notNull(inv, "The inventory must not be null.");
        Validate.notNull(operation, "The MachineOperation must not be null.");
        if (this.getProgressBar() == null) {
            return;
        }
        int remainingTicks = operation.getRemainingTicks();
        int totalTicks = operation.getTotalTicks();
        if (remainingTicks > 0 || totalTicks > 0) {
            ChestMenuUtils.updateProgressbar(inv, slot, remainingTicks, totalTicks, this.getProgressBar());
        }
    }
}

