/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONArray;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

class ToObjectMapper {
    private static Map<Predicate<JsonElement>, Function<JsonElement, Object>> mappers = new HashMap<Predicate<JsonElement>, Function<JsonElement, Object>>();

    ToObjectMapper() {
    }

    private static Object mapPrimative(JsonPrimitive e) {
        if (e.isBoolean()) {
            return e.getAsBoolean();
        }
        if (e.isNumber()) {
            String s = e.getAsString();
            if (s.contains(".")) {
                return e.getAsDouble();
            }
            if ((long)e.getAsInt() == e.getAsLong()) {
                return e.getAsInt();
            }
            return e.getAsLong();
        }
        return e.getAsString();
    }

    public Object apply(JsonElement e) {
        return mappers.entrySet().stream().filter(r -> ((Predicate)r.getKey()).test(e)).map(r -> ((Function)r.getValue()).apply(e)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        mappers.put(j -> j == null || j.isJsonNull(), j -> null);
        mappers.put(JsonElement::isJsonArray, JSONArray::new);
        mappers.put(JsonElement::isJsonObject, JSONObject::new);
        mappers.put(JsonElement::isJsonPrimitive, j -> ToObjectMapper.mapPrimative(j.getAsJsonPrimitive()));
    }
}

