/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.sounds;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundConfiguration;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public enum SoundEffect {
    ANCIENT_ALTAR_ITEM_CHECK_SOUND(Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 2.0f),
    ANCIENT_ALTAR_ITEM_DROP_SOUND(Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 1.0f, 1.0f),
    ANCIENT_ALTAR_ITEM_PICK_UP_SOUND(Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f),
    ANCIENT_ALTAR_FINISH_SOUND(Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f),
    ANCIENT_ALTAR_START_SOUND(Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 1.0f, 1.0f),
    ANCIENT_PEDESTAL_ITEM_PLACE_SOUND(Sound.ENTITY_ITEM_PICKUP, 0.5f, 0.5f),
    ARMOR_FORGE_FINISH_SOUND(Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f),
    ARMOR_FORGE_WORKING_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    AUTO_CRAFTER_GUI_CLICK_SOUND(Sound.UI_BUTTON_CLICK, 1.0f, 1.0f),
    AUTO_CRAFTER_UPDATE_RECIPE(Sound.UI_BUTTON_CLICK, 1.0f, 1.0f),
    AUTOMATED_PANNING_MACHINE_FAIL_SOUND(Sound.ENTITY_ARMOR_STAND_BREAK, 1.0f, 1.0f),
    AUTOMATED_PANNING_MACHINE_SUCCESS_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    BEE_BOOTS_FALL_SOUND(Sound.BLOCK_HONEY_BLOCK_FALL, 1.0f, 1.0f),
    BACKPACK_CLOSE_SOUND(Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f),
    BACKPACK_OPEN_SOUND(Sound.ENTITY_HORSE_ARMOR, 1.0f, 1.0f),
    COMPOSTER_COMPOST_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    COMPRESSOR_CRAFT_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    COMPRESSOR_CRAFT_CONTRACT_SOUND(Sound.BLOCK_PISTON_CONTRACT, 1.0f, 1.0f),
    COMPRESSOR_CRAFT_EXTEND_SOUND(Sound.BLOCK_PISTON_EXTEND, 1.0f, 1.0f),
    COOLER_CONSUME_SOUND(Sound.ENTITY_GENERIC_DRINK, 1.0f, 1.0f),
    CRUCIBLE_ADD_WATER_SOUND(Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f),
    CRUCIBLE_ADD_LAVA_SOUND(Sound.BLOCK_LAVA_POP, 1.0f, 1.0f),
    CRUCIBLE_BLOCK_BREAK_SOUND(Sound.BLOCK_METAL_BREAK, 1.0f, 1.0f),
    CRUCIBLE_GENERATE_LIQUID_SOUND(Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f),
    CRUCIBLE_INTERACT_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    CRUCIBLE_PLACE_LAVA_SOUND(Sound.BLOCK_LAVA_POP, 1.0f, 1.0f),
    CRUCIBLE_PLACE_WATER_SOUND(Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f),
    DEBUG_FISH_CLICK_SOUND(Sound.BLOCK_BAMBOO_PLACE, 1.0f, 1.0f),
    DIET_COOKIE_CONSUME_SOUND(Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f),
    ENCHANTMENT_RUNE_ADD_ENCHANT_SOUND(Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f),
    ENDER_BACKPACK_OPEN_SOUND(Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f),
    ENHANCED_CRAFTING_TABLE_CRAFT_SOUND(Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f),
    ELYTRA_CAP_IMPACT_SOUND(Sound.BLOCK_STONE_HIT, 1.0f, 1.0f),
    EXPLOSIVE_BOW_HIT_SOUND(Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f),
    EXPLOSIVE_TOOL_EXPLODE_SOUND(Sound.ENTITY_GENERIC_EXPLODE, 0.2f, 1.0f),
    FISHERMAN_ANDROID_FISHING_SOUND(Sound.ENTITY_PLAYER_SPLASH, 0.3f, 0.7f),
    FLASK_OF_KNOWLEDGE_FILLUP_SOUND(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.5f),
    GUIDE_BUTTON_CLICK_SOUND(Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f),
    GUIDE_CONTRIBUTORS_OPEN_SOUND(Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f),
    GUIDE_LANGUAGE_OPEN_SOUND(Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f),
    GUIDE_OPEN_SETTING_SOUND(Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f),
    GRIND_STONE_INTERACT_SOUND(Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f),
    IGNITION_CHAMBER_USE_FLINT_AND_STEEL_SOUND(Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f),
    INFUSED_HOPPER_TELEPORT_SOUND(Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 2.0f),
    INFUSED_MAGNET_TELEPORT_SOUND(Sound.ENTITY_ENDERMAN_TELEPORT, 0.25f, 0.9f),
    IRON_GOLEM_ASSEMBLER_ASSEMBLE_SOUND(Sound.ENTITY_IRON_GOLEM_REPAIR, 0.5f, 1.0f),
    JETBOOTS_THRUST_SOUND(Sound.ENTITY_TNT_PRIMED, 0.25f, 1.0f),
    JETPACK_THRUST_SOUND(Sound.ENTITY_GENERIC_EXPLODE, 0.25f, 1.0f),
    JUICER_USE_SOUND(Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f),
    LIMITED_USE_ITEM_BREAK_SOUND(Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f),
    MAGICAL_EYE_OF_ENDER_USE_SOUND(Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f),
    MAGIC_SUGAR_CONSUME_SOUND(Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f),
    MAGIC_WORKBENCH_FINISH_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    MAGIC_WORKBENCH_START_ANIMATION_SOUND(Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f),
    MINER_ANDROID_BLOCK_GENERATION_SOUND(Sound.BLOCK_FIRE_EXTINGUISH, 0.075f, 0.8f),
    MINING_TASK_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 0.2f, 1.0f),
    ORE_WASHER_WASH_SOUND(Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f),
    PLAYER_RESEARCHING_SOUND(Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f),
    PORTABLE_DUSTBIN_OPEN_SOUND(Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f),
    PORTABLE_CRAFTER_OPEN_SOUND(Sound.BLOCK_WOODEN_BUTTON_CLICK_ON, 1.0f, 1.0f),
    PRESSURE_CHAMBER_FINISH_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f),
    PRESSURE_CHAMBER_WORKING_SOUND(Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f),
    PROGRAMMABLE_ANDROID_SCRIPT_DOWNLOAD_SOUND(Sound.BLOCK_NOTE_BLOCK_HAT, 0.7f, 0.7f),
    SLIME_BOOTS_FALL_SOUND(Sound.BLOCK_SLIME_BLOCK_FALL, 1.0f, 1.0f),
    TELEPORTATION_MANAGER_OPEN_GUI(Sound.UI_BUTTON_CLICK, 1.0f, 1.0f),
    GPS_NETWORK_ADD_WAYPOINT(Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f),
    GPS_NETWORK_CREATE_WAYPOINT(Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f),
    GPS_NETWORK_OPEN_PANEL_SOUND(Sound.UI_BUTTON_CLICK, 1.0f, 1.0f),
    SMELTERY_CRAFT_SOUND(Sound.BLOCK_LAVA_POP, 1.0f, 1.0f),
    SOULBOUND_RUNE_RITUAL_SOUND(Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f),
    SPLINT_CONSUME_SOUND(Sound.ENTITY_SKELETON_HURT, 1.0f, 1.0f),
    STOMPER_BOOTS_STOMP_SOUND(Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 2.0f),
    TAPE_MEASURE_MEASURE_SOUND(Sound.ITEM_BOOK_PUT, 1.0f, 0.7f),
    TOME_OF_KNOWLEDGE_USE_SOUND(Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f),
    TELEPORT_UPDATE_SOUND(Sound.BLOCK_BEACON_AMBIENT, 1.0f, 0.6f),
    TELEPORT_SOUND(Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f),
    VAMPIRE_BLADE_HEALING_SOUND(Sound.ENTITY_ARROW_HIT_PLAYER, 0.7f, 0.7f),
    VANILLA_AUTO_CRAFTER_UPDATE_RECIPE_SOUND(Sound.UI_BUTTON_CLICK, 1.0f, 1.0f),
    VILLAGER_RUNE_TRANSFORM_SOUND(Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.4f),
    VITAMINS_CONSUME_SOUND(Sound.ENTITY_GENERIC_EAT, 1.0f, 1.0f),
    WIND_STAFF_USE_SOUND(Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);

    private final String defaultSound;
    private final float defaultVolume;
    private final float defaultPitch;

    private SoundEffect(String sound, float volume, float pitch) {
        Preconditions.checkNotNull((Object)sound, (Object)"The Sound id cannot be null!");
        Preconditions.checkArgument((volume >= 0.0f ? 1 : 0) != 0, (Object)"The volume cannot be a negative number.");
        Preconditions.checkArgument(((double)pitch >= 0.5 ? 1 : 0) != 0, (Object)"A pitch below 0.5 has no effect on the sound.");
        this.defaultSound = sound;
        this.defaultVolume = volume;
        this.defaultPitch = pitch;
    }

    private SoundEffect(Sound sound, float volume, float pitch) {
        Preconditions.checkNotNull((Object)sound, (Object)"The Sound id cannot be null!");
        Preconditions.checkArgument((volume >= 0.0f ? 1 : 0) != 0, (Object)"The volume cannot be a negative number.");
        Preconditions.checkArgument(((double)pitch >= 0.5 ? 1 : 0) != 0, (Object)"A pitch below 0.5 has no effect on the sound.");
        this.defaultSound = sound.getKey().getKey();
        this.defaultVolume = volume;
        this.defaultPitch = pitch;
    }

    @Nullable
    private SoundConfiguration getConfiguration() {
        SoundConfiguration config = Slimefun.getSoundService().getConfiguration(this);
        if (config == null) {
            Slimefun.logger().log(Level.WARNING, "Could not find any sound configuration for: {0}", this.name());
        }
        return config;
    }

    public void playFor(@Nonnull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Cannot play sounds to a Player that is null!");
        SoundConfiguration config = this.getConfiguration();
        if (config != null) {
            Location loc = player.getEyeLocation();
            player.playSound(loc, config.getSoundId(), SoundCategory.PLAYERS, config.getVolume(), config.getPitch());
        }
    }

    public void playAt(@Nonnull Location loc, @Nonnull SoundCategory category) {
        Preconditions.checkNotNull((Object)loc, (Object)"The location should not be null.");
        SoundConfiguration config = this.getConfiguration();
        if (config != null && loc.getWorld() != null) {
            loc.getWorld().playSound(loc, config.getSoundId(), category, config.getVolume(), config.getPitch());
        }
    }

    public void playAt(@Nonnull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"The block cannot be null.");
        this.playAt(block.getLocation(), SoundCategory.BLOCKS);
    }

    @Nonnull
    public String getDefaultSoundId() {
        return this.defaultSound;
    }

    public float getDefaultVolume() {
        return this.defaultVolume;
    }

    public float getDefaultPitch() {
        return this.defaultPitch;
    }
}

