/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.events.ExplosiveToolBreakBlocksEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosiveTool
extends SimpleSlimefunItem<ToolUseHandler>
implements NotPlaceable,
DamageableItem {
    private final ItemSetting<Boolean> damageOnUse = new ItemSetting<Boolean>(this, "damage-on-use", true);
    private final ItemSetting<Boolean> callExplosionEvent = new ItemSetting<Boolean>(this, "call-explosion-event", false);

    @ParametersAreNonnullByDefault
    public ExplosiveTool(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.damageOnUse, this.callExplosionEvent);
    }

    @Override
    @Nonnull
    public ToolUseHandler getItemHandler() {
        return (e, tool, fortune, drops) -> {
            Player p = e.getPlayer();
            if (!p.isSneaking()) {
                Block b = e.getBlock();
                b.getWorld().createExplosion(b.getLocation(), 0.0f);
                SoundEffect.EXPLOSIVE_TOOL_EXPLODE_SOUND.playAt(b);
                List<Block> blocks = this.findBlocks(b);
                this.breakBlocks(e, p, tool, b, blocks, drops);
            }
        };
    }

    @ParametersAreNonnullByDefault
    private void breakBlocks(BlockBreakEvent e, Player p, ItemStack item, Block b, List<Block> blocks, List<ItemStack> drops) {
        ArrayList<Block> blocksToDestroy = new ArrayList<Block>();
        if (this.callExplosionEvent.getValue().booleanValue()) {
            BlockExplodeEvent blockExplodeEvent = new BlockExplodeEvent(b, blocks, 0.0f);
            Bukkit.getServer().getPluginManager().callEvent((Event)blockExplodeEvent);
            if (!blockExplodeEvent.isCancelled()) {
                for (Block block : blockExplodeEvent.blockList()) {
                    if (!this.canBreak(p, block)) continue;
                    blocksToDestroy.add(block);
                }
            }
        } else {
            for (Block block : blocks) {
                if (!this.canBreak(p, block)) continue;
                blocksToDestroy.add(block);
            }
        }
        ExplosiveToolBreakBlocksEvent event = new ExplosiveToolBreakBlocksEvent(p, b, blocksToDestroy, item, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (Block block : blocksToDestroy) {
                this.breakBlock(e, p, item, block, drops);
            }
        }
    }

    @Nonnull
    private List<Block> findBlocks(@Nonnull Block b) {
        ArrayList<Block> blocks = new ArrayList<Block>(26);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    blocks.add(b.getRelative(x, y, z));
                }
            }
        }
        return blocks;
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse.getValue();
    }

    protected boolean canBreak(@Nonnull Player p, @Nonnull Block b) {
        if (b.isEmpty() || b.isLiquid()) {
            return false;
        }
        if (SlimefunTag.UNBREAKABLE_MATERIALS.isTagged(b.getType())) {
            return false;
        }
        if (!b.getWorld().getWorldBorder().isInside(b.getLocation())) {
            return false;
        }
        if (Slimefun.getIntegrations().isCustomBlock(b)) {
            return false;
        }
        return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.BREAK_BLOCK);
    }

    @ParametersAreNonnullByDefault
    private void breakBlock(BlockBreakEvent e, Player p, ItemStack item, Block b, List<ItemStack> drops) {
        Slimefun.getProtectionManager().logAction((OfflinePlayer)p, b, Interaction.BREAK_BLOCK);
        Material material = b.getType();
        b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)material);
        SlimefunItem sfItem = BlockStorage.check(b);
        if (sfItem != null && !sfItem.useVanillaBlockBreaking()) {
            BlockBreakEvent dummyEvent = new BlockBreakEvent(b, e.getPlayer());
            sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onPlayerBreak(dummyEvent, item, drops));
            if (!dummyEvent.isCancelled()) {
                drops.addAll(sfItem.getDrops(p));
                b.setType(Material.AIR);
                BlockStorage.clearBlockInfo(b);
            }
        } else {
            b.breakNaturally(item);
        }
        this.damageItem(p, item);
    }
}

