/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class Waypoint {
    private final PlayerProfile profile;
    private final String id;
    private final String name;
    private final Location location;

    @ParametersAreNonnullByDefault
    public Waypoint(PlayerProfile profile, String id, Location loc, String name) {
        Validate.notNull(profile, "Profile must never be null!");
        Validate.notNull(id, "id must never be null!");
        Validate.notNull(loc, "Location must never be null!");
        Validate.notNull(name, "Name must never be null!");
        this.profile = profile;
        this.id = id;
        this.location = loc;
        this.name = name;
    }

    @Nonnull
    public PlayerProfile getOwner() {
        return this.profile;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public boolean isDeathpoint() {
        return this.name.startsWith("player:death ");
    }

    @Nonnull
    public ItemStack getIcon() {
        return Slimefun.getGPSNetwork().getIcon(this.name, this.location.getWorld().getEnvironment());
    }

    public int hashCode() {
        return Objects.hash(this.profile.getUUID(), this.id, this.name, this.location);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Waypoint)) {
            return false;
        }
        Waypoint waypoint = (Waypoint)obj;
        return this.profile.getUUID().equals(waypoint.getOwner().getUUID()) && this.id.equals(waypoint.getId()) && this.location.equals((Object)waypoint.getLocation()) && this.name.equals(waypoint.getName());
    }
}

