/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.staves;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.LimitedUseItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class StormStaff
extends LimitedUseItem {
    public static final int MAX_USES = 8;
    private static final NamespacedKey usageKey = new NamespacedKey((Plugin)Slimefun.instance(), "stormstaff_usage");

    @ParametersAreNonnullByDefault
    public StormStaff(ItemGroup group, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(group, item, recipeType, recipe);
        this.setMaxUseCount(8);
    }

    @Override
    @Nonnull
    protected NamespacedKey getStorageKey() {
        return usageKey;
    }

    @Override
    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            if (p.getFoodLevel() >= 4 || p.getGameMode() == GameMode.CREATIVE) {
                Location loc = p.getTargetBlock(null, 30).getLocation();
                if (loc.getWorld() != null && loc.getChunk().isLoaded()) {
                    if (loc.getWorld().getPVP() && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, loc, Interaction.ATTACK_PLAYER)) {
                        e.cancel();
                        this.useItem(p, item, loc);
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.no-pvp", true);
                    }
                }
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.hungry", true);
            }
        };
    }

    @ParametersAreNonnullByDefault
    private void useItem(Player p, ItemStack item, Location loc) {
        World world = loc.getWorld();
        if (world != null) {
            world.strikeLightning(loc);
        }
        if (item.getType() == Material.SHEARS) {
            return;
        }
        if (p.getGameMode() != GameMode.CREATIVE) {
            FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)p, p.getFoodLevel() - 4);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                p.setFoodLevel(event.getFoodLevel());
            }
        }
        this.damageItem(p, item);
    }
}

