/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Body;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Path;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;

class SummaryFormatter
implements Function<HttpRequest<?>, String> {
    SummaryFormatter() {
    }

    @Override
    public String apply(HttpRequest<?> req) {
        StringJoiner sb = new StringJoiner(System.lineSeparator());
        sb.add(req.getHttpMethod().name() + " " + req.getUrl());
        req.getHeaders().all().forEach(h -> sb.add(h.getName() + "=" + h.getValue()));
        sb.add("===================================");
        this.addBody(req, sb);
        return sb.toString();
    }

    private void addBody(HttpRequest<?> req, StringJoiner sb) {
        req.getBody().ifPresent(b -> {
            if (b.isEntityBody()) {
                sb.add(String.valueOf(b.uniPart().getValue()));
            } else if (b.isMultiPart()) {
                this.toMultiPartAproximation((Body)b, sb);
            } else {
                Path path = new Path("/");
                b.multiParts().stream().filter(p -> !p.isFile()).forEach(p -> path.queryString(p.getName(), p.getValue()));
                sb.add(path.getQueryString());
            }
        });
    }

    private String toMultiPartAproximation(Body b, StringJoiner sj) {
        b.multiParts().forEach(p -> {
            String partid = UUID.randomUUID().toString();
            sj.add("--" + partid);
            if (p.isFile()) {
                sj.add(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", p.getName(), p.getFileName()));
                sj.add("Content-Type: application/octet-stream");
                sj.add("<BINARY DATA>");
            } else {
                sj.add("Content-Disposition: form-data; name:\"" + p.getName() + "\"");
                sj.add(String.valueOf(p.getValue()));
            }
            sj.add("");
        });
        return sj.toString();
    }
}

