/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockInfoConfig;
import me.mrCookieSlime.Slimefun.api.EmptyBlockData;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public class BlockStorage {
    private static final String PATH_BLOCKS = "data-storage/Slimefun/stored-blocks/";
    private static final String PATH_CHUNKS = "data-storage/Slimefun/stored-chunks/";
    private static final String PATH_INVENTORIES = "data-storage/Slimefun/stored-inventories/";
    private static final EmptyBlockData emptyBlockData = new EmptyBlockData();
    private final World world;
    private final Map<Location, Config> storage = new ConcurrentHashMap<Location, Config>();
    private final Map<Location, BlockMenu> inventories = new ConcurrentHashMap<Location, BlockMenu>();
    private final Map<String, Config> blocksCache = new ConcurrentHashMap<String, Config>();
    private static int chunkChanges = 0;
    private static boolean universalInventoriesLoaded = false;
    private int changes = 0;
    private AtomicBoolean isMarkedForRemoval = new AtomicBoolean(false);

    @Nullable
    public static BlockStorage getStorage(@Nonnull World world) {
        return Slimefun.getRegistry().getWorlds().get(world.getName());
    }

    @Nonnull
    public static BlockStorage getOrCreate(@Nonnull World world) {
        BlockStorage storage = Slimefun.getRegistry().getWorlds().get(world.getName());
        if (storage == null) {
            return new BlockStorage(world);
        }
        return storage;
    }

    private static String serializeLocation(Location l) {
        return l.getWorld().getName() + ";" + l.getBlockX() + ";" + l.getBlockY() + ";" + l.getBlockZ();
    }

    private static String serializeChunk(World world, int x, int z) {
        return world.getName() + ";Chunk;" + x + ";" + z;
    }

    private static Location deserializeLocation(String l) {
        try {
            String[] components = CommonPatterns.SEMICOLON.split(l);
            if (components.length != 4) {
                return null;
            }
            World w = Bukkit.getWorld((String)components[0]);
            if (w != null) {
                return new Location(w, (double)Integer.parseInt(components[1]), (double)Integer.parseInt(components[2]), (double)Integer.parseInt(components[3]));
            }
        }
        catch (NumberFormatException x) {
            Slimefun.logger().log(Level.WARNING, "Could not parse Number", x);
        }
        return null;
    }

    public BlockStorage(World w) {
        this.world = w;
        if (this.world.getName().indexOf(46) != -1) {
            throw new IllegalArgumentException("Slimefun cannot deal with World names that contain a dot: " + w.getName());
        }
        if (Slimefun.getRegistry().getWorlds().containsKey(w.getName())) {
            return;
        }
        Slimefun.logger().log(Level.INFO, "Loading Blocks for World \"{0}\"", w.getName());
        Slimefun.logger().log(Level.INFO, "This may take a long time...");
        File dir = new File(PATH_BLOCKS + w.getName());
        if (dir.exists()) {
            this.loadBlocks(dir);
        } else {
            dir.mkdirs();
        }
        this.loadChunks();
        if (!Slimefun.instance().isUnitTest()) {
            this.loadInventories();
        }
        Slimefun.getRegistry().getWorlds().put(this.world.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlocks(File directory) {
        long total = directory.listFiles().length;
        long start = System.currentTimeMillis();
        long done = 0L;
        long timestamp = System.currentTimeMillis();
        long totalBlocks = 0L;
        int delay = Slimefun.getCfg().getInt("URID.info-delay");
        try {
            for (File file : directory.listFiles()) {
                if (file.getName().equals("null.sfb")) {
                    Slimefun.logger().log(Level.WARNING, "File with corrupted blocks detected!");
                    Slimefun.logger().log(Level.WARNING, "Slimefun will simply skip this File, you should look inside though!");
                    Slimefun.logger().log(Level.WARNING, file.getPath());
                    continue;
                }
                if (!file.getName().endsWith(".sfb")) continue;
                if (timestamp + (long)delay < System.currentTimeMillis()) {
                    int progress = Math.round((float)done * 100.0f / (float)total * 100.0f / 100.0f);
                    Slimefun.logger().log(Level.INFO, "Loading Blocks... {0}% done (\"{1}\")", new Object[]{progress, this.world.getName()});
                    timestamp = System.currentTimeMillis();
                }
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                for (String key : cfg.getKeys(false)) {
                    this.loadBlock(file, (FileConfiguration)cfg, key);
                    ++totalBlocks;
                }
                ++done;
            }
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            Slimefun.logger().log(Level.INFO, "Loading Blocks... 100% (FINISHED - {0}ms)", time);
            Slimefun.logger().log(Level.INFO, "Loaded a total of {0} Blocks for World \"{1}\"", new Object[]{totalBlocks, this.world.getName()});
            if (totalBlocks > 0L) {
                Slimefun.logger().log(Level.INFO, "Avg: {0}ms/Block", NumberUtils.roundDecimalNumber((double)time / (double)totalBlocks));
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        Slimefun.logger().log(Level.INFO, "Loading Blocks... 100% (FINISHED - {0}ms)", time);
        Slimefun.logger().log(Level.INFO, "Loaded a total of {0} Blocks for World \"{1}\"", new Object[]{totalBlocks, this.world.getName()});
        if (totalBlocks > 0L) {
            Slimefun.logger().log(Level.INFO, "Avg: {0}ms/Block", NumberUtils.roundDecimalNumber((double)time / (double)totalBlocks));
        }
    }

    private void loadBlock(File file, FileConfiguration cfg, String key) {
        Location l = BlockStorage.deserializeLocation(key);
        if (l == null) {
            return;
        }
        try {
            String json = cfg.getString(key);
            BlockInfoConfig blockInfo = BlockStorage.parseBlockInfo(l, json);
            if (blockInfo != null && ((Config)blockInfo).contains("id")) {
                if (this.storage.putIfAbsent(l, blockInfo) != null) {
                    if (Slimefun.getRegistry().logDuplicateBlockEntries()) {
                        Slimefun.logger().log(Level.INFO, "Ignoring duplicate block @ {0}, {1}, {2} ({3} -> {4})", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ(), ((Config)blockInfo).getString("id"), this.storage.get(l).getString("id")});
                    }
                    return;
                }
                String fileName = file.getName().replace(".sfb", "");
                if (Slimefun.getRegistry().getTickerBlocks().contains(fileName)) {
                    Slimefun.getTickerTask().enableTicker(l);
                }
            }
        }
        catch (Exception x) {
            Slimefun.logger().log(Level.WARNING, x, () -> "Failed to load " + file.getName() + "(" + key + ") for Slimefun " + Slimefun.getVersion());
        }
    }

    private void loadChunks() {
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        if (chunks.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)chunks);
            for (String key : cfg.getKeys(false)) {
                try {
                    if (!this.world.getName().equals(CommonPatterns.SEMICOLON.split(key)[0])) continue;
                    BlockInfoConfig data = new BlockInfoConfig(BlockStorage.parseJSON(cfg.getString(key)));
                    Slimefun.getRegistry().getChunks().put(key, data);
                }
                catch (Exception x) {
                    Slimefun.logger().log(Level.WARNING, x, () -> "Failed to load " + chunks.getName() + " in World " + this.world.getName() + "(" + key + ") for Slimefun " + Slimefun.getVersion());
                }
            }
        }
    }

    private void loadInventories() {
        for (File file : new File("data-storage/Slimefun/stored-inventories").listFiles()) {
            if (!file.getName().startsWith(this.world.getName()) || !file.getName().endsWith(".sfi")) continue;
            try {
                Location l = BlockStorage.deserializeLocation(file.getName().replace(".sfi", ""));
                if (this.world != l.getWorld()) continue;
                io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config cfg = new io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config(file);
                BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                if (preset == null) {
                    preset = BlockMenuPreset.getPreset(BlockStorage.checkID(l));
                }
                if (preset == null) continue;
                this.inventories.put(l, new BlockMenu(preset, l, cfg));
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An Error occurred while loading this Block Inventory: " + file.getName());
            }
        }
        if (universalInventoriesLoaded) {
            return;
        }
        universalInventoriesLoaded = true;
        for (File file : new File("data-storage/Slimefun/universal-inventories").listFiles()) {
            if (!file.getName().endsWith(".sfi")) continue;
            try {
                io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config cfg = new io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config(file);
                BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                if (preset == null) continue;
                Slimefun.getRegistry().getUniversalInventories().put(preset.getID(), new UniversalBlockMenu(preset, cfg));
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An Error occurred while loading this universal Inventory: " + file.getName());
            }
        }
    }

    public void computeChanges() {
        this.changes = this.blocksCache.size();
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            this.changes += ((BlockMenu)entry.getValue()).getUnsavedChanges();
        }
        HashMap<String, UniversalBlockMenu> universalInventories2 = new HashMap<String, UniversalBlockMenu>(Slimefun.getRegistry().getUniversalInventories());
        for (Map.Entry entry : universalInventories2.entrySet()) {
            this.changes += ((UniversalBlockMenu)entry.getValue()).getUnsavedChanges();
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public void save() {
        this.computeChanges();
        if (this.changes == 0) {
            return;
        }
        Slimefun.logger().log(Level.INFO, "Saving block data for world \"{0}\" ({1} change(s) queued)", new Object[]{this.world.getName(), this.changes});
        HashMap<String, Config> cache = new HashMap<String, Config>(this.blocksCache);
        for (Map.Entry entry : cache.entrySet()) {
            this.blocksCache.remove(entry.getKey());
            Config config = (Config)entry.getValue();
            if (config.getKeys().isEmpty()) {
                File file = config.getFile();
                if (!file.exists()) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    Slimefun.logger().log(Level.WARNING, e, () -> "Could not delete file \"" + file.getName() + "\"");
                }
                continue;
            }
            File tmpFile = new File(config.getFile().getParentFile(), config.getFile().getName() + ".tmp");
            config.save(tmpFile);
            try {
                Files.move(tmpFile.toPath(), config.getFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An Error occurred while copying a temporary File for Slimefun " + Slimefun.getVersion());
            }
        }
        HashMap<Location, BlockMenu> unsavedInventories = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : unsavedInventories.entrySet()) {
            ((BlockMenu)entry.getValue()).save((Location)entry.getKey());
        }
        HashMap<String, UniversalBlockMenu> hashMap = new HashMap<String, UniversalBlockMenu>(Slimefun.getRegistry().getUniversalInventories());
        for (Map.Entry entry : hashMap.entrySet()) {
            ((UniversalBlockMenu)entry.getValue()).save();
        }
        this.changes = 0;
    }

    public void saveAndRemove() {
        this.save();
        BlockStorage.saveChunks();
        this.isMarkedForRemoval.set(true);
    }

    public boolean isMarkedForRemoval() {
        return this.isMarkedForRemoval.get();
    }

    public static void saveChunks() {
        if (chunkChanges > 0) {
            File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
            Config cfg = new Config("data-storage/Slimefun/stored-chunks/chunks.temp");
            for (Map.Entry<String, BlockInfoConfig> entry : Slimefun.getRegistry().getChunks().entrySet()) {
                if (entry.getValue().getKeys().isEmpty()) continue;
                cfg.setValue(entry.getKey(), entry.getValue().toJSON());
            }
            cfg.save(chunks);
            chunkChanges = 0;
        }
    }

    @Nonnull
    public Map<Location, Config> getRawStorage() {
        return ImmutableMap.copyOf(this.storage);
    }

    @Nullable
    public static Map<Location, Config> getRawStorage(@Nonnull World world) {
        Validate.notNull(world, "World cannot be null!");
        BlockStorage storage = BlockStorage.getStorage(world);
        if (storage != null) {
            return storage.getRawStorage();
        }
        return null;
    }

    public static void store(Block block, ItemStack item) {
        SlimefunItem sfitem = SlimefunItem.getByItem(item);
        if (sfitem != null) {
            BlockStorage.addBlockInfo(block, "id", sfitem.getId(), true);
        }
    }

    public static void store(Block block, String item) {
        BlockStorage.addBlockInfo(block, "id", item, true);
    }

    @Nullable
    public static ItemStack retrieve(@Nonnull Block block) {
        SlimefunItem item = BlockStorage.check(block);
        if (item == null) {
            return null;
        }
        BlockStorage.clearBlockInfo(block);
        return item.getItem();
    }

    @Nonnull
    public static Config getLocationInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            return emptyBlockData;
        }
        Config cfg = storage.storage.get(l);
        return cfg == null ? emptyBlockData : cfg;
    }

    @Nonnull
    private static Map<String, String> parseJSON(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (json != null && json.length() > 2) {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(json).getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return map;
    }

    private static BlockInfoConfig parseBlockInfo(Location l, String json) {
        try {
            return new BlockInfoConfig(BlockStorage.parseJSON(json));
        }
        catch (Exception x) {
            Logger logger = Slimefun.logger();
            logger.log(Level.WARNING, x.getClass().getName());
            logger.log(Level.WARNING, "Failed to parse BlockInfo for Block @ {0}, {1}, {2}", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ()});
            logger.log(Level.WARNING, json);
            logger.log(Level.WARNING, "");
            logger.log(Level.WARNING, "IGNORE THIS ERROR UNLESS IT IS SPAMMING");
            logger.log(Level.WARNING, "");
            logger.log(Level.SEVERE, x, () -> "An Error occurred while parsing Block Info for Slimefun " + Slimefun.getVersion());
            return null;
        }
    }

    private static String serializeBlockInfo(Config cfg) {
        String string;
        StringWriter string2 = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)string2);
        try {
            writer.setLenient(true);
            writer.beginObject();
            for (String key : cfg.getKeys()) {
                writer.name(key).value(cfg.getString(key));
            }
            writer.endObject();
            string = string2.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException x) {
                Slimefun.logger().log(Level.SEVERE, "An error occurred while serializing BlockInfo", x);
                return null;
            }
        }
        writer.close();
        return string;
    }

    public static String getLocationInfo(Location l, String key) {
        return BlockStorage.getLocationInfo(l).getString(key);
    }

    public static void addBlockInfo(Location l, String key, String value) {
        BlockStorage.addBlockInfo(l, key, value, false);
    }

    public static void addBlockInfo(Block block, String key, String value) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value);
    }

    public static void addBlockInfo(Block block, String key, String value, boolean updateTicker) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value, updateTicker);
    }

    public static void addBlockInfo(Location l, String key, String value, boolean updateTicker) {
        Config cfg = BlockStorage.getLocationInfo(l);
        if (cfg == emptyBlockData) {
            cfg = new BlockInfoConfig();
        }
        cfg.setValue(key, value);
        BlockStorage.setBlockInfo(l, cfg, updateTicker);
    }

    public static boolean hasBlockInfo(Block block) {
        return BlockStorage.hasBlockInfo(block.getLocation());
    }

    public static boolean hasBlockInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage != null) {
            Config cfg = storage.storage.get(l);
            return cfg != null && cfg.getString("id") != null;
        }
        return false;
    }

    private static void setBlockInfo(Location l, Config cfg, boolean updateTicker) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            Slimefun.logger().warning("Could not set Block info for non-registered World '" + l.getWorld().getName() + "'. Is some plugin trying to store data in a fake world?");
            return;
        }
        storage.storage.put(l, cfg);
        String id = cfg.getString("id");
        BlockMenuPreset preset = BlockMenuPreset.getPreset(id);
        if (preset != null) {
            if (BlockMenuPreset.isUniversalInventory(id)) {
                Slimefun.getRegistry().getUniversalInventories().computeIfAbsent(id, key -> new UniversalBlockMenu(preset));
            } else if (!storage.hasInventory(l)) {
                File file = new File(PATH_INVENTORIES + BlockStorage.serializeLocation(l) + ".sfi");
                if (file.exists()) {
                    BlockMenu inventory = new BlockMenu(preset, l, new io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config(file));
                    storage.inventories.put(l, inventory);
                } else {
                    storage.loadInventory(l, preset);
                }
            }
        }
        BlockStorage.refreshCache(storage, l, id, BlockStorage.serializeBlockInfo(cfg), updateTicker);
    }

    public static void setBlockInfo(Block b, String json, boolean updateTicker) {
        BlockStorage.setBlockInfo(b.getLocation(), json, updateTicker);
    }

    public static void setBlockInfo(Location l, String json, boolean updateTicker) {
        BlockInfoConfig blockInfo;
        BlockInfoConfig blockInfoConfig = blockInfo = json == null ? new BlockInfoConfig() : BlockStorage.parseBlockInfo(l, json);
        if (blockInfo == null) {
            return;
        }
        BlockStorage.setBlockInfo(l, blockInfo, updateTicker);
    }

    public static void clearBlockInfo(Block block) {
        BlockStorage.clearBlockInfo(block.getLocation());
    }

    public static void clearBlockInfo(Location l) {
        BlockStorage.clearBlockInfo(l, true);
    }

    public static void clearBlockInfo(Block b, boolean destroy) {
        BlockStorage.clearBlockInfo(b.getLocation(), destroy);
    }

    public static void clearBlockInfo(Location l, boolean destroy) {
        Slimefun.getTickerTask().queueDelete(l, destroy);
    }

    public static void clearAllBlockInfoAtChunk(Chunk chunk, boolean destroy) {
        BlockStorage.clearAllBlockInfoAtChunk(chunk.getWorld(), chunk.getX(), chunk.getZ(), destroy);
    }

    public static void clearAllBlockInfoAtChunk(World world, int chunkX, int chunkZ, boolean destroy) {
        BlockStorage blockStorage = BlockStorage.getStorage(world);
        if (blockStorage == null) {
            return;
        }
        HashMap<Location, Boolean> toClear = new HashMap<Location, Boolean>();
        Map<Location, Config> storage = blockStorage.getRawStorage();
        for (Location location : storage.keySet()) {
            if (location.getBlockX() >> 4 != chunkX || location.getBlockZ() >> 4 != chunkZ) continue;
            toClear.put(location, destroy);
        }
        Slimefun.getTickerTask().queueDelete(toClear);
    }

    public static void deleteLocationInfoUnsafely(Location l, boolean destroy) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            throw new IllegalStateException("World \"" + l.getWorld().getName() + "\" seems to have been deleted. Do not call unsafe methods directly!");
        }
        if (BlockStorage.hasBlockInfo(l)) {
            BlockStorage.refreshCache(storage, l, BlockStorage.getLocationInfo(l).getString("id"), null, destroy);
            storage.storage.remove(l);
        }
        if (destroy) {
            UniversalBlockMenu universalInventory;
            if (storage.hasInventory(l)) {
                storage.clearInventory(l);
            }
            if ((universalInventory = BlockStorage.getUniversalInventory(l)) != null) {
                universalInventory.close();
                universalInventory.save();
            }
            Slimefun.getTickerTask().disableTicker(l);
        }
    }

    @ParametersAreNonnullByDefault
    public static void moveBlockInfo(Location from, Location to) {
        Slimefun.getTickerTask().queueMove(from, to);
    }

    @ParametersAreNonnullByDefault
    public static void moveLocationInfoUnsafely(Location from, Location to) {
        if (!BlockStorage.hasBlockInfo(from)) {
            return;
        }
        BlockStorage storage = BlockStorage.getStorage(from.getWorld());
        Config previousData = BlockStorage.getLocationInfo(from);
        BlockStorage.setBlockInfo(to, previousData, true);
        if (storage.inventories.containsKey(from)) {
            BlockMenu menu = storage.inventories.get(from);
            storage.inventories.put(to, menu);
            storage.clearInventory(from);
            menu.move(to);
        }
        BlockStorage.refreshCache(storage, from, previousData.getString("id"), null, true);
        storage.storage.remove(from);
        Slimefun.getTickerTask().disableTicker(from);
    }

    private static void refreshCache(BlockStorage storage, Location l, String key, String value, boolean updateTicker) {
        SlimefunItem item;
        if (key == null) {
            return;
        }
        Config cfg = storage.blocksCache.computeIfAbsent(key, k -> new Config(PATH_BLOCKS + l.getWorld().getName() + "/" + key + ".sfb"));
        cfg.setValue(BlockStorage.serializeLocation(l), value);
        if (updateTicker && (item = SlimefunItem.getById(key)) != null && value != null && l.getWorld() != null && item.isTicking() && !item.isDisabledIn(l.getWorld())) {
            Slimefun.getTickerTask().enableTicker(l);
        }
    }

    @Nullable
    public static SlimefunItem check(@Nonnull Block b) {
        String id = BlockStorage.checkID(b);
        return id == null ? null : SlimefunItem.getById(id);
    }

    @Nullable
    public static SlimefunItem check(@Nonnull Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? null : SlimefunItem.getById(id);
    }

    public static boolean check(Block block, String slimefunItem) {
        String id = BlockStorage.checkID(block);
        return id != null && id.equals(slimefunItem);
    }

    @Nullable
    public static String checkID(@Nonnull Block b) {
        Optional<String> blockData;
        if (Bukkit.isPrimaryThread() && Slimefun.getBlockDataService().isTileEntity(b.getType()) && (blockData = Slimefun.getBlockDataService().getBlockData(b)).isPresent()) {
            return blockData.get();
        }
        return BlockStorage.checkID(b.getLocation());
    }

    @Nullable
    public static String checkID(@Nonnull Location l) {
        return BlockStorage.getLocationInfo(l, "id");
    }

    public static boolean check(@Nonnull Location l, @Nullable String slimefunItem) {
        if (slimefunItem == null) {
            return false;
        }
        String id = BlockStorage.checkID(l);
        return id != null && id.equals(slimefunItem);
    }

    public static boolean isWorldLoaded(@Nonnull World world) {
        return Slimefun.getRegistry().getWorlds().containsKey(world.getName());
    }

    public BlockMenu loadInventory(Location l, BlockMenuPreset preset) {
        if (preset == null) {
            return null;
        }
        BlockMenu menu = new BlockMenu(preset, l);
        this.inventories.put(l, menu);
        return menu;
    }

    public void reloadInventory(Location l) {
        BlockMenu menu = this.inventories.get(l);
        if (menu != null) {
            menu.reload();
        }
    }

    public void clearInventory(Location l) {
        BlockMenu menu = BlockStorage.getInventory(l);
        if (menu != null) {
            for (HumanEntity human : new ArrayList(menu.toInventory().getViewers())) {
                Slimefun.runSync(() -> ((HumanEntity)human).closeInventory());
            }
            this.inventories.get(l).delete(l);
            this.inventories.remove(l);
        }
    }

    public boolean hasInventory(Location l) {
        return this.inventories.containsKey(l);
    }

    public static boolean hasUniversalInventory(String id) {
        return Slimefun.getRegistry().getUniversalInventories().containsKey(id);
    }

    public static UniversalBlockMenu getUniversalInventory(Block block) {
        return BlockStorage.getUniversalInventory(block.getLocation());
    }

    public static UniversalBlockMenu getUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? null : BlockStorage.getUniversalInventory(id);
    }

    public static UniversalBlockMenu getUniversalInventory(String id) {
        return Slimefun.getRegistry().getUniversalInventories().get(id);
    }

    public static BlockMenu getInventory(Block b) {
        return BlockStorage.getInventory(b.getLocation());
    }

    public static boolean hasInventory(Block b) {
        BlockStorage storage = BlockStorage.getStorage(b.getWorld());
        if (storage == null) {
            return false;
        }
        return storage.hasInventory(b.getLocation());
    }

    public static BlockMenu getInventory(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            return null;
        }
        BlockMenu menu = storage.inventories.get(l);
        if (menu != null) {
            return menu;
        }
        return storage.loadInventory(l, BlockMenuPreset.getPreset(BlockStorage.checkID(l)));
    }

    public static Config getChunkInfo(World world, int x, int z) {
        try {
            if (!BlockStorage.isWorldLoaded(world)) {
                return emptyBlockData;
            }
            String key = BlockStorage.serializeChunk(world, x, z);
            BlockInfoConfig cfg = Slimefun.getRegistry().getChunks().get(key);
            if (cfg == null) {
                cfg = new BlockInfoConfig();
                Slimefun.getRegistry().getChunks().put(key, cfg);
            }
            return cfg;
        }
        catch (Exception e) {
            Slimefun.logger().log(Level.SEVERE, e, () -> "Failed to parse ChunkInfo for Slimefun " + Slimefun.getVersion());
            return emptyBlockData;
        }
    }

    public static void setChunkInfo(World world, int x, int z, String key, String value) {
        String serializedChunk = BlockStorage.serializeChunk(world, x, z);
        BlockInfoConfig cfg = Slimefun.getRegistry().getChunks().get(serializedChunk);
        if (cfg == null) {
            cfg = new BlockInfoConfig();
            Slimefun.getRegistry().getChunks().put(serializedChunk, cfg);
        }
        cfg.setValue(key, value);
        ++chunkChanges;
    }

    public static boolean hasChunkInfo(World world, int x, int z) {
        String serializedChunk = BlockStorage.serializeChunk(world, x, z);
        return Slimefun.getRegistry().getChunks().containsKey(serializedChunk);
    }

    public static String getChunkInfo(World world, int x, int z, String key) {
        return BlockStorage.getChunkInfo(world, x, z).getString(key);
    }

    public static String getBlockInfoAsJson(Block block) {
        return BlockStorage.getBlockInfoAsJson(block.getLocation());
    }

    public static String getBlockInfoAsJson(Location l) {
        return BlockStorage.serializeBlockInfo(BlockStorage.getLocationInfo(l));
    }

    public boolean hasUniversalInventory(Block block) {
        return this.hasUniversalInventory(block.getLocation());
    }

    public boolean hasUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id != null && BlockStorage.hasUniversalInventory(id);
    }
}

