/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.Jetpack;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AbstractPlayerTask;
import javax.annotation.Nonnull;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class JetpackTask
extends AbstractPlayerTask {
    private static final float COST = 0.08f;
    private final Jetpack jetpack;

    public JetpackTask(@Nonnull Player p, @Nonnull Jetpack jetpack) {
        super(p);
        this.jetpack = jetpack;
    }

    @Override
    protected void executeTask() {
        if (this.p.getInventory().getChestplate() == null || this.p.getInventory().getChestplate().getType() == Material.AIR) {
            return;
        }
        if (this.jetpack.removeItemCharge(this.p.getInventory().getChestplate(), 0.08f)) {
            SoundEffect.JETPACK_THRUST_SOUND.playAt(this.p.getLocation(), SoundCategory.PLAYERS);
            this.p.getWorld().playEffect(this.p.getLocation(), Effect.SMOKE, 1, 1);
            this.p.setFallDistance(0.0f);
            Vector vector = new Vector(0, 1, 0);
            vector.multiply(this.jetpack.getThrust());
            vector.add(this.p.getEyeLocation().getDirection().multiply(0.2f));
            this.p.setVelocity(vector);
        } else {
            this.cancel();
        }
    }
}

