/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Juicer
extends MultiBlockMachine {
    @ParametersAreNonnullByDefault
    public Juicer(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, new ItemStack(Material.GLASS), null, null, new ItemStack(Material.NETHER_BRICK_FENCE), null, null, new CustomItemStack(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), null}, BlockFace.SELF);
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes.stream().map(items -> items[0]).collect(Collectors.toList());
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(possibleDispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            for (ItemStack current : inv.getContents()) {
                for (ItemStack convert : RecipeType.getRecipeInputs(this)) {
                    if (convert == null || !SlimefunUtils.isItemSimilar(current, convert, true)) continue;
                    ItemStack adding = RecipeType.getRecipeOutput(this, convert);
                    Inventory outputInv = this.findOutputInventory(adding, possibleDispenser, inv);
                    if (outputInv != null) {
                        ItemStack removing = current.clone();
                        removing.setAmount(1);
                        inv.removeItem(new ItemStack[]{removing});
                        outputInv.addItem(new ItemStack[]{adding});
                        SoundEffect.JUICER_USE_SOUND.playAt(b);
                        p.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)Material.HAY_BLOCK);
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                    }
                    return;
                }
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }
}

