/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideEntry;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public class GuideHistory {
    private final PlayerProfile profile;
    private final Deque<GuideEntry<?>> queue = new LinkedList();
    private int mainMenuPage = 1;

    public GuideHistory(@Nonnull PlayerProfile profile) {
        Validate.notNull(profile, "Cannot create a GuideHistory without a PlayerProfile!");
        this.profile = profile;
    }

    public void clear() {
        this.queue.clear();
    }

    public void setMainMenuPage(int page) {
        Validate.isTrue(page >= 1, "page must be greater than 0!");
        this.mainMenuPage = page;
    }

    public int getMainMenuPage() {
        return this.mainMenuPage;
    }

    public void add(@Nonnull ItemGroup itemGroup, int page) {
        this.refresh(itemGroup, page);
    }

    public void add(@Nonnull ItemStack item, int page) {
        this.refresh(item, page);
    }

    public void add(@Nonnull SlimefunItem item) {
        Validate.notNull(item, "Cannot add a non-existing SlimefunItem to the GuideHistory!");
        this.queue.add(new GuideEntry<SlimefunItem>(item, 0));
    }

    public void add(@Nonnull String searchTerm) {
        Validate.notNull(searchTerm, "Cannot add an empty Search Term to the GuideHistory!");
        this.queue.add(new GuideEntry<String>(searchTerm, 0));
    }

    private <T> void refresh(@Nonnull T object, int page) {
        Validate.notNull(object, "Cannot add a null Entry to the GuideHistory!");
        Validate.isTrue(page >= 0, "page must not be negative!");
        GuideEntry<?> lastEntry = this.getLastEntry(false);
        if (lastEntry != null && lastEntry.getIndexedObject().equals(object)) {
            lastEntry.setPage(page);
        } else {
            this.queue.add(new GuideEntry<T>(object, page));
        }
    }

    public int size() {
        return this.queue.size();
    }

    @Nullable
    private GuideEntry<?> getLastEntry(boolean remove) {
        if (remove && !this.queue.isEmpty()) {
            this.queue.removeLast();
        }
        return this.queue.isEmpty() ? null : this.queue.getLast();
    }

    public void openLastEntry(@Nonnull SlimefunGuideImplementation guide) {
        GuideEntry<?> entry = this.getLastEntry(false);
        this.open(guide, entry);
    }

    public void goBack(@Nonnull SlimefunGuideImplementation guide) {
        GuideEntry<?> entry = this.getLastEntry(true);
        this.open(guide, entry);
    }

    private <T> void open(@Nonnull SlimefunGuideImplementation guide, @Nullable GuideEntry<T> entry) {
        if (entry == null) {
            guide.openMainMenu(this.profile, this.mainMenuPage);
        } else {
            T t = entry.getIndexedObject();
            if (t instanceof ItemGroup) {
                ItemGroup group = (ItemGroup)t;
                guide.openItemGroup(this.profile, group, entry.getPage());
            } else {
                t = entry.getIndexedObject();
                if (t instanceof SlimefunItem) {
                    SlimefunItem item = (SlimefunItem)t;
                    guide.displayItem(this.profile, item, false);
                } else {
                    t = entry.getIndexedObject();
                    if (t instanceof ItemStack) {
                        ItemStack stack = (ItemStack)t;
                        guide.displayItem(this.profile, stack, entry.getPage(), false);
                    } else {
                        t = entry.getIndexedObject();
                        if (t instanceof String) {
                            String query = (String)t;
                            guide.openSearch(this.profile, query, false);
                        } else {
                            throw new IllegalStateException("Unknown GuideHistory entry: " + entry.getIndexedObject());
                        }
                    }
                }
            }
        }
    }
}

