/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Effect;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

abstract class AbstractSmeltery
extends MultiBlockMachine {
    @ParametersAreNonnullByDefault
    protected AbstractSmeltery(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, BlockFace trigger) {
        super(itemGroup, item, recipe, trigger);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(possibleDispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
            for (int i = 0; i < inputs.size(); ++i) {
                if (!this.canCraft(inv, inputs, i)) continue;
                ItemStack output = RecipeType.getRecipeOutputList(this, inputs.get(i)).clone();
                if (SlimefunUtils.canPlayerUseItem(p, output, true)) {
                    Inventory outputInv = this.findOutputInventory(output, possibleDispenser, inv);
                    if (outputInv != null) {
                        this.craft(p, b, inv, inputs.get(i), output, outputInv);
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                    }
                }
                return;
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }

    private boolean canCraft(Inventory inv, List<ItemStack[]> inputs, int i) {
        block0: for (ItemStack expectedInput : inputs.get(i)) {
            if (expectedInput == null) continue;
            for (int j = 0; j < inv.getContents().length; ++j) {
                if (j == inv.getContents().length - 1 && !SlimefunUtils.isItemSimilar(inv.getContents()[j], expectedInput, true)) {
                    return false;
                }
                if (SlimefunUtils.isItemSimilar(inv.getContents()[j], expectedInput, true)) continue block0;
            }
        }
        return true;
    }

    protected void craft(Player p, Block b, Inventory inv, ItemStack[] recipe, ItemStack output, Inventory outputInv) {
        for (ItemStack removing : recipe) {
            if (removing == null) continue;
            InvUtils.removeItem(inv, removing.getAmount(), true, stack -> SlimefunUtils.isItemSimilar(stack, removing, true));
        }
        outputInv.addItem(new ItemStack[]{output});
        SoundEffect.SMELTERY_CRAFT_SOUND.playAt(b);
        p.getWorld().playEffect(b.getLocation(), Effect.MOBSPAWNER_FLAMES, 1);
    }
}

