/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomItemDataService
implements Keyed {
    private final NamespacedKey namespacedKey;

    public CustomItemDataService(@Nonnull Plugin plugin, @Nonnull String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setItemData(@Nonnull ItemStack item, @Nonnull String id) {
        Validate.notNull(item, "The Item cannot be null!");
        Validate.notNull(id, "Cannot store null on an Item!");
        ItemMeta im = item.getItemMeta();
        this.setItemData(im, id);
        item.setItemMeta(im);
    }

    public void setItemData(@Nonnull ItemMeta meta, @Nonnull String id) {
        Validate.notNull(meta, "The ItemMeta cannot be null!");
        Validate.notNull(id, "Cannot store null on an ItemMeta!");
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.namespacedKey, PersistentDataType.STRING, (Object)id);
    }

    @Nonnull
    public Optional<String> getItemData(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return Optional.empty();
        }
        return this.getItemData(item.getItemMeta());
    }

    @Nonnull
    public Optional<String> getItemData(@Nonnull ItemMeta meta) {
        Validate.notNull(meta, "Cannot read data from null!");
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return Optional.ofNullable((String)container.get(this.namespacedKey, PersistentDataType.STRING));
    }

    public boolean hasEqualItemData(@Nonnull ItemMeta meta1, @Nonnull ItemMeta meta2) {
        Validate.notNull(meta1, "Cannot read data from null (first arg)");
        Validate.notNull(meta2, "Cannot read data from null (second arg)");
        Optional<String> data1 = this.getItemData(meta1);
        if (data1.isPresent()) {
            Optional<String> data2 = this.getItemData(meta2);
            return data2.isPresent() && data1.equals(data2);
        }
        return false;
    }
}

