/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ChatUtils {
    private ChatUtils() {
    }

    public static void sendURL(@Nonnull CommandSender sender, @Nonnull String url) {
        sender.sendMessage("");
        Slimefun.getLocalization().sendMessage(sender, "messages.link-prompt", false);
        sender.sendMessage(ChatColors.color("&7&o" + url));
        sender.sendMessage("");
    }

    @Nonnull
    public static String removeColorCodes(@Nonnull String string) {
        return ChatColor.stripColor((String)ChatColors.color(string));
    }

    @Nonnull
    public static String crop(@Nonnull ChatColor color, @Nonnull String string) {
        if (ChatColor.stripColor((String)(color + string)).length() > 19) {
            return (color + ChatColor.stripColor((String)string)).substring(0, 18) + "...";
        }
        return color + ChatColor.stripColor((String)string);
    }

    @Nonnull
    public static String christmas(@Nonnull String text) {
        return ChatColors.alternating(text, ChatColor.GREEN, ChatColor.RED);
    }

    public static void awaitInput(@Nonnull Player p, @Nonnull Consumer<String> callback) {
        ChatInput.waitForPlayer((Plugin)Slimefun.instance(), p, callback);
    }

    @Nonnull
    public static String humanize(@Nonnull String string) {
        StringBuilder builder = new StringBuilder();
        String[] segments = CommonPatterns.UNDERSCORE.split(string.toLowerCase(Locale.ROOT));
        builder.append(Character.toUpperCase(segments[0].charAt(0))).append(segments[0].substring(1));
        for (int i = 1; i < segments.length; ++i) {
            String segment = segments[i];
            builder.append(' ').append(Character.toUpperCase(segment.charAt(0))).append(segment.substring(1));
        }
        return builder.toString();
    }
}

