/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BaseResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import java.util.Objects;

public class JsonResponse
extends BaseResponse<JsonNode> {
    private JsonNode node;

    protected JsonResponse(RawResponse response) {
        super(response);
        this.node = this.getNode(response);
    }

    private JsonNode getNode(RawResponse response) {
        if (Objects.isNull(response) || !response.hasContent()) {
            return new JsonNode(null);
        }
        String json = response.getContentAsString();
        return this.toJsonNode(json);
    }

    private JsonNode toJsonNode(String json) {
        try {
            return new JsonNode(json);
        }
        catch (RuntimeException e) {
            super.setParsingException(json, e);
            return null;
        }
    }

    @Override
    public JsonNode getBody() {
        return this.node;
    }

    @Override
    protected String getRawBody() {
        return this.node.toString();
    }
}

