/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.AbstractCraftingTable;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EnhancedCraftingTable
extends AbstractCraftingTable {
    @ParametersAreNonnullByDefault
    public EnhancedCraftingTable(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, null, null, null, new ItemStack(Material.CRAFTING_TABLE), null, null, new ItemStack(Material.DISPENSER), null}, BlockFace.SELF);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(possibleDispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
            for (ItemStack[] input : inputs) {
                if (!this.isCraftable(inv, input)) continue;
                ItemStack output = RecipeType.getRecipeOutputList(this, input).clone();
                if (SlimefunUtils.canPlayerUseItem(p, output, true)) {
                    this.craft(inv, possibleDispenser, p, b, output);
                }
                return;
            }
            if (inv.isEmpty()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
            }
        }
    }

    private void craft(Inventory inv, Block dispenser, Player p, Block b, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            SlimefunItem sfItem = SlimefunItem.getByItem(output);
            if (sfItem instanceof SlimefunBackpack) {
                SlimefunBackpack backpack = (SlimefunBackpack)sfItem;
                this.upgradeBackpack(p, inv, backpack, output);
            }
            for (int j = 0; j < 9; ++j) {
                ItemStack item = inv.getContents()[j];
                if (item == null || item.getType() == Material.AIR) continue;
                ItemUtils.consumeItem(item, true);
            }
            SoundEffect.ENHANCED_CRAFTING_TABLE_CRAFT_SOUND.playAt(b);
            outputInv.addItem(new ItemStack[]{output});
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], true)) continue;
            if (SlimefunItem.getByItem(recipe[j]) instanceof SlimefunBackpack) {
                if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], false)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

