/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.sounds;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundConfiguration;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.plugin.Plugin;

public class SoundService {
    private final Config config;
    private final Map<SoundEffect, SoundConfiguration> soundMap = new EnumMap<SoundEffect, SoundConfiguration>(SoundEffect.class);

    public SoundService(@Nonnull Slimefun plugin) {
        this.config = new Config((Plugin)plugin, "sounds.yml");
        this.config.getConfiguration().options().header("This file is used to assign the sounds which Slimefun will play.\nYou can fully customize any sound you want and even change their pitch\nand volume. To disable a sound, simply set the volume to zero.\n");
        this.config.getConfiguration().options().parseComments(true);
    }

    public void reload(boolean save) {
        this.config.reload();
        for (SoundEffect sound : SoundEffect.values()) {
            try {
                this.reloadSound(sound);
            }
            catch (Exception | LinkageError x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An exception was thrown while trying to load the configuration data for the following sound:" + sound.name());
            }
        }
        if (save) {
            this.config.save();
        }
    }

    private void reloadSound(@Nonnull SoundEffect sound) {
        this.config.setDefaultValue(sound.name() + ".sound", sound.getDefaultSoundId());
        this.config.setDefaultValue(sound.name() + ".volume", Float.valueOf(sound.getDefaultVolume()));
        this.config.setDefaultValue(sound.name() + ".pitch", Float.valueOf(sound.getDefaultPitch()));
        String soundId = this.config.getString(sound.name() + ".sound");
        float volume = this.config.getFloat(sound.name() + ".volume");
        float pitch = this.config.getFloat(sound.name() + ".pitch");
        if (volume < 0.0f) {
            Slimefun.logger().log(Level.WARNING, "Invalid value in sounds.yml! Volume for Sound \"{0}\" was {1} (must be at least 0.0)", new Object[]{sound.name(), Float.valueOf(volume)});
            volume = 0.0f;
        }
        if (pitch < 0.5f) {
            Slimefun.logger().log(Level.WARNING, "Invalid value in sounds.yml! Pitch for Sound \"{0}\" was {1} (must be at least 0.5)", new Object[]{sound.name(), Float.valueOf(pitch)});
            pitch = 0.5f;
        }
        SoundConfiguration configuration = new SoundConfiguration(soundId, volume, pitch);
        this.soundMap.put(sound, configuration);
    }

    @Nullable
    public SoundConfiguration getConfiguration(@Nonnull SoundEffect sound) {
        Preconditions.checkNotNull((Object)((Object)sound), (Object)"The sound must not be null!");
        return this.soundMap.get((Object)sound);
    }
}

