/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GoldPan;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ElectricGoldPan
extends AContainer
implements RecipeDisplayItem {
    private final ItemSetting<Boolean> overrideOutputLimit = new ItemSetting<Boolean>(this, "override-output-limit", false);
    private final GoldPan goldPan = SlimefunItems.GOLD_PAN.getItem(GoldPan.class);
    private final GoldPan netherGoldPan = SlimefunItems.NETHER_GOLD_PAN.getItem(GoldPan.class);
    private final ItemStack gravel = new ItemStack(Material.GRAVEL);
    private final ItemStack soulSand = new ItemStack(Material.SOUL_SAND);

    @ParametersAreNonnullByDefault
    public ElectricGoldPan(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.overrideOutputLimit);
    }

    public boolean isOutputLimitOverriden() {
        return this.overrideOutputLimit.getValue();
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> recipes = new ArrayList<ItemStack>();
        recipes.addAll(this.goldPan.getDisplayRecipes());
        recipes.addAll(this.netherGoldPan.getDisplayRecipes());
        return recipes;
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_SHOVEL);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        if (!this.isOutputLimitOverriden() && !this.hasFreeSlot(menu)) {
            return null;
        }
        for (int slot : this.getInputSlots()) {
            MachineRecipe recipe;
            ItemStack output;
            ItemStack item = menu.getItemInSlot(slot);
            if (SlimefunUtils.isItemSimilar(item, this.gravel, true, false)) {
                output = this.goldPan.getRandomOutput();
                recipe = new MachineRecipe(3 / this.getSpeed(), new ItemStack[]{this.gravel}, new ItemStack[]{output});
                if (output.getType() == Material.AIR || !menu.fits(output, this.getOutputSlots())) continue;
                menu.consumeItem(slot);
                return recipe;
            }
            if (!SlimefunUtils.isItemSimilar(item, this.soulSand, true, false)) continue;
            output = this.netherGoldPan.getRandomOutput();
            recipe = new MachineRecipe(4 / this.getSpeed(), new ItemStack[]{this.soulSand}, new ItemStack[]{output});
            if (output.getType() == Material.AIR || !menu.fits(output, this.getOutputSlots())) continue;
            menu.consumeItem(slot);
            return recipe;
        }
        return null;
    }

    private boolean hasFreeSlot(@Nonnull BlockMenu menu) {
        for (int slot : this.getOutputSlots()) {
            if (menu.getItemInSlot(slot) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_GOLD_PAN";
    }
}

