/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.PluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.PrefixedVersion;
import java.io.File;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;

public class UpdaterService {
    private final Slimefun plugin;
    private final PluginUpdater<PrefixedVersion> updater;
    private final SlimefunBranch branch;

    public UpdaterService(@Nonnull Slimefun plugin, @Nonnull String version, @Nonnull File file) {
        this.plugin = plugin;
        GitHubBuildsUpdater autoUpdater = null;
        if (version.contains("UNOFFICIAL")) {
            this.branch = SlimefunBranch.UNOFFICIAL;
        } else if (version.startsWith("DEV - ")) {
            try {
                autoUpdater = new GitHubBuildsUpdater((Plugin)plugin, file, "TheBusyBiscuit/Slimefun4/master");
            }
            catch (Exception x) {
                plugin.getLogger().log(Level.SEVERE, "Failed to create AutoUpdater", x);
            }
            this.branch = SlimefunBranch.DEVELOPMENT;
        } else if (version.startsWith("RC - ")) {
            try {
                autoUpdater = new GitHubBuildsUpdater((Plugin)plugin, file, "TheBusyBiscuit/Slimefun4/stable", "RC - ");
            }
            catch (Exception x) {
                plugin.getLogger().log(Level.SEVERE, "Failed to create AutoUpdater", x);
            }
            this.branch = SlimefunBranch.STABLE;
        } else {
            this.branch = SlimefunBranch.UNKNOWN;
        }
        this.updater = autoUpdater;
    }

    @Nonnull
    public SlimefunBranch getBranch() {
        return this.branch;
    }

    public int getBuildNumber() {
        if (this.updater != null) {
            PrefixedVersion version = this.updater.getCurrentVersion();
            return version.getVersionNumber();
        }
        return -1;
    }

    public void start() {
        if (this.updater != null) {
            this.updater.start();
        } else {
            this.printBorder();
            this.plugin.getLogger().log(Level.WARNING, "It looks like you are using an unofficially modified build of Slimefun!");
            this.plugin.getLogger().log(Level.WARNING, "Auto-Updates have been disabled, this build is not considered safe.");
            this.plugin.getLogger().log(Level.WARNING, "Do not report bugs encountered in this Version of Slimefun to any official sources.");
            this.printBorder();
        }
    }

    public boolean isEnabled() {
        return Slimefun.getCfg().getBoolean("options.auto-update") && this.updater != null;
    }

    public void disable() {
        this.printBorder();
        this.plugin.getLogger().log(Level.WARNING, "It looks like you have disabled auto-updates for Slimefun!");
        this.plugin.getLogger().log(Level.WARNING, "Auto-Updates keep your server safe, performant and bug-free.");
        this.plugin.getLogger().log(Level.WARNING, "We respect your decision.");
        if (this.branch != SlimefunBranch.STABLE) {
            this.plugin.getLogger().log(Level.WARNING, "If you are just scared of Slimefun breaking, then please consider using a \"stable\" build instead of disabling auto-updates.");
        }
        this.printBorder();
    }

    private void printBorder() {
        this.plugin.getLogger().log(Level.WARNING, "#######################################################");
    }
}

