/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public enum InfiniteBlockGenerator implements Predicate<Block>
{
    COBBLESTONE_GENERATOR("COBBLESTONE"),
    STONE_GENERATOR("STONE"),
    BASALT_GENERATOR("BASALT");

    private static final InfiniteBlockGenerator[] valuesCached;
    private static final BlockFace[] sameLevelFaces;
    private final Material material;

    private InfiniteBlockGenerator(String type) {
        this.material = Material.matchMaterial((String)type);
    }

    @Nullable
    public Material getGeneratedMaterial() {
        return this.material;
    }

    @Override
    public boolean test(@Nonnull Block b) {
        Validate.notNull(b, "Block cannot be null!");
        if (b.getType() == this.getGeneratedMaterial()) {
            switch (this) {
                case COBBLESTONE_GENERATOR: {
                    return this.hasSurroundingMaterials(b, Material.WATER, Material.LAVA);
                }
                case STONE_GENERATOR: {
                    if (b.getRelative(BlockFace.UP).getType() == Material.LAVA) {
                        return this.hasSurroundingMaterials(b, Material.WATER);
                    }
                    return false;
                }
                case BASALT_GENERATOR: {
                    if (b.getRelative(BlockFace.DOWN).getType() == Material.SOUL_SOIL) {
                        return this.hasSurroundingMaterials(b, Material.LAVA, Material.BLUE_ICE);
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    private boolean hasSurroundingMaterials(Block b, Material ... materials) {
        Validate.notNull(b, "The Block cannot be null!");
        Validate.notEmpty(materials, "Materials need to have a size of at least one!");
        boolean[] matches = new boolean[materials.length];
        int count = 0;
        for (BlockFace face : sameLevelFaces) {
            Block neighbour = b.getRelative(face);
            Material neighbourType = neighbour.getType();
            for (int i = 0; i < materials.length; ++i) {
                if (neighbourType != materials[i] || matches[i]) continue;
                matches[i] = true;
                ++count;
                break;
            }
            if (count != materials.length) continue;
            return true;
        }
        return count == materials.length;
    }

    @Nonnull
    public BlockFormEvent callEvent(@Nonnull Block block) {
        Validate.notNull(block, "The Block cannot be null!");
        BlockState state = PaperLib.getBlockState(block, false).getState();
        BlockFormEvent event = new BlockFormEvent(block, state);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public static InfiniteBlockGenerator findAt(@Nonnull Block b) {
        Validate.notNull(b, "Cannot find a generator without a Location!");
        for (InfiniteBlockGenerator generator : valuesCached) {
            if (!generator.test(b)) continue;
            return generator;
        }
        return null;
    }

    static {
        valuesCached = InfiniteBlockGenerator.values();
        sameLevelFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    }
}

