/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.armor;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class StomperBoots
extends SlimefunItem {
    @ParametersAreNonnullByDefault
    public StomperBoots(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public void stomp(@Nonnull EntityDamageEvent fallDamageEvent) {
        Player player = (Player)fallDamageEvent.getEntity();
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 2.0f);
        player.setVelocity(new Vector(0.0, 0.7, 0.0));
        for (Entity entity : player.getNearbyEntities(4.0, 4.0, 4.0)) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.canPush(player, livingEntity = (LivingEntity)entity)) continue;
            Vector velocity = this.getShockwave(player.getLocation(), entity.getLocation());
            entity.setVelocity(velocity);
            if (entity instanceof Player && (!player.getWorld().getPVP() || !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, entity.getLocation(), Interaction.ATTACK_PLAYER))) continue;
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)player, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, fallDamageEvent.getDamage() / 2.0);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            livingEntity.damage(event.getDamage());
        }
        for (BlockFace face : BlockFace.values()) {
            Block block = player.getLocation().getBlock().getRelative(BlockFace.DOWN).getRelative(face);
            player.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
        }
    }

    @Nonnull
    protected Vector getShockwave(@Nonnull Location origin, @Nonnull Location target) {
        if (origin.distanceSquared(target) < 0.05) {
            return new Vector(0, 1, 0);
        }
        Vector direction = target.toVector().subtract(origin.toVector());
        return direction.normalize().multiply(1.4);
    }

    protected boolean canPush(@Nonnull Player player, @Nonnull LivingEntity entity) {
        return entity.isValid() && !entity.getUniqueId().equals(player.getUniqueId()) && entity.isCollidable() && entity.hasGravity();
    }
}

