/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidInstance;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ButcherAndroidListener
implements Listener {
    private static final String METADATA_KEY = "android_killer";

    public ButcherAndroidListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeath(EntityDeathEvent e) {
        if (e.getEntity().hasMetadata(METADATA_KEY)) {
            AndroidInstance obj = (AndroidInstance)((MetadataValue)e.getEntity().getMetadata(METADATA_KEY).get(0)).value();
            Slimefun.runSync(() -> {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Entity n : e.getEntity().getNearbyEntities(0.5, 0.5, 0.5)) {
                    if (!(n instanceof Item)) continue;
                    Item item = (Item)n;
                    if (!n.isValid() || SlimefunUtils.hasNoPickupFlag(item)) continue;
                    items.add(item.getItemStack());
                    n.remove();
                }
                this.addExtraDrops(items, e.getEntityType());
                obj.getAndroid().addItems(obj.getBlock(), items.toArray(new ItemStack[0]));
                ExperienceOrb exp = (ExperienceOrb)e.getEntity().getWorld().spawnEntity(e.getEntity().getLocation(), EntityType.EXPERIENCE_ORB);
                exp.setExperience(1 + ThreadLocalRandom.current().nextInt(6));
            }, 1L);
            e.getEntity().removeMetadata(METADATA_KEY, (Plugin)Slimefun.instance());
        }
    }

    @ParametersAreNonnullByDefault
    private void addExtraDrops(List<ItemStack> drops, EntityType entityType) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (entityType == EntityType.WITHER_SKELETON && ((Random)random).nextInt(250) < 2) {
            drops.add(new ItemStack(Material.WITHER_SKELETON_SKULL));
        }
        if (entityType == EntityType.BLAZE) {
            drops.add(new ItemStack(Material.BLAZE_ROD, 1 + ((Random)random).nextInt(1)));
        }
    }
}

