/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SoulboundListener
implements Listener {
    private final Map<UUID, Map<Integer, ItemStack>> soulbound = new HashMap<UUID, Map<Integer, ItemStack>>();

    public SoulboundListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onDamage(PlayerDeathEvent e) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        Player p = e.getEntity();
        for (int slot = 0; slot < p.getInventory().getSize(); ++slot) {
            ItemStack item = p.getInventory().getItem(slot);
            if (!SlimefunUtils.isSoulbound(item, p.getWorld())) continue;
            items.put(slot, item);
        }
        Map<Integer, ItemStack> existingItems = this.soulbound.get(p.getUniqueId());
        if (existingItems == null) {
            this.soulbound.put(p.getUniqueId(), items);
        } else {
            existingItems.putAll(items);
        }
        e.getDrops().removeIf(itemStack -> SlimefunUtils.isSoulbound(itemStack, p.getWorld()));
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        this.returnSoulboundItems(e.getPlayer());
    }

    private void returnSoulboundItems(@Nonnull Player p) {
        Map<Integer, ItemStack> items = this.soulbound.remove(p.getUniqueId());
        if (items != null) {
            for (Map.Entry<Integer, ItemStack> entry : items.entrySet()) {
                p.getInventory().setItem(entry.getKey().intValue(), entry.getValue());
            }
        }
    }
}

