/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class ChestMenuUtils {
    private static final ItemStack UI_BACKGROUND = new SlimefunItemStack("_UI_BACKGROUND", Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
    private static final ItemStack INPUT_SLOT = new SlimefunItemStack("_UI_INPUT_SLOT", Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]);
    private static final ItemStack OUTPUT_SLOT = new SlimefunItemStack("_UI_OUTPUT_SLOT", Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]);
    private static final ItemStack NO_PERMISSION = new SlimefunItemStack("_UI_NO_PERMISSION", Material.BARRIER, "No Permission", new String[0]);
    private static final ItemStack NOT_RESEARCHED = new SlimefunItemStack("_UI_NOT_RESEARCHED", Material.BARRIER, "Not researched", new String[0]);
    private static final ItemStack BACK_BUTTON = new SlimefunItemStack("_UI_BACK", Material.ENCHANTED_BOOK, "&7\u21e6 Back", meta -> meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS}));
    private static final ItemStack MENU_BUTTON = new SlimefunItemStack("_UI_MENU", Material.COMPARATOR, "&eSettings / Info", "", "&7\u21e8 Click to see more");
    private static final ItemStack SEARCH_BUTTON = new SlimefunItemStack("_UI_SEARCH", Material.NAME_TAG, "&bSearch", new String[0]);
    private static final ItemStack WIKI_BUTTON = new SlimefunItemStack("_UI_WIKI", Material.KNOWLEDGE_BOOK, "&3Slimefun Wiki", new String[0]);
    private static final ItemStack PREV_BUTTON_ACTIVE = new SlimefunItemStack("_UI_PREVIOUS_ACTIVE", Material.LIME_STAINED_GLASS_PANE, "&r\u21e6 Previous Page", new String[0]);
    private static final ItemStack NEXT_BUTTON_ACTIVE = new SlimefunItemStack("_UI_NEXT_ACTIVE", Material.LIME_STAINED_GLASS_PANE, "&rNext Page \u21e8", new String[0]);
    private static final ItemStack PREV_BUTTON_INACTIVE = new SlimefunItemStack("_UI_PREVIOUS_INACTIVE", Material.BLACK_STAINED_GLASS_PANE, "&8\u21e6 Previous Page", new String[0]);
    private static final ItemStack NEXT_BUTTON_INACTIVE = new SlimefunItemStack("_UI_NEXT_INACTIVE", Material.BLACK_STAINED_GLASS_PANE, "&8Next Page \u21e8", new String[0]);
    private static final ChestMenu.MenuClickHandler CLICK_HANDLER = (p, s, i, a) -> false;

    private ChestMenuUtils() {
    }

    @Nonnull
    public static ItemStack getBackground() {
        return UI_BACKGROUND;
    }

    @Nonnull
    public static ItemStack getNoPermissionItem() {
        return NO_PERMISSION;
    }

    @Nonnull
    public static ItemStack getNotResearchedItem() {
        return NOT_RESEARCHED;
    }

    @Nonnull
    public static ItemStack getInputSlotTexture() {
        return INPUT_SLOT;
    }

    @Nonnull
    public static ItemStack getOutputSlotTexture() {
        return OUTPUT_SLOT;
    }

    @Nonnull
    public static ChestMenu.MenuClickHandler getEmptyClickHandler() {
        return CLICK_HANDLER;
    }

    @Nonnull
    public static ItemStack getBackButton(@Nonnull Player p, String ... lore) {
        return new CustomItemStack(BACK_BUTTON, "&7\u21e6 " + Slimefun.getLocalization().getMessage(p, "guide.back.title"), lore);
    }

    @Nonnull
    public static ItemStack getMenuButton(@Nonnull Player p) {
        return new CustomItemStack(MENU_BUTTON, ChatColor.YELLOW + Slimefun.getLocalization().getMessage(p, "guide.title.settings"), "", "&7\u21e8 " + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup"));
    }

    @Nonnull
    public static ItemStack getSearchButton(@Nonnull Player p) {
        return new CustomItemStack(SEARCH_BUTTON, meta -> {
            meta.setDisplayName(ChatColors.color(Slimefun.getLocalization().getMessage(p, "guide.search.name")));
            List<String> lore = Arrays.asList("", ChatColor.GRAY + "\u21e8 " + Slimefun.getLocalization().getMessage(p, "guide.search.tooltip"));
            lore.replaceAll(ChatColors::color);
            meta.setLore(lore);
        });
    }

    @Nonnull
    public static ItemStack getWikiButton() {
        return WIKI_BUTTON;
    }

    @Nonnull
    public static ItemStack getPreviousButton(@Nonnull Player p, int page, int pages) {
        if (pages == 1 || page == 1) {
            return new CustomItemStack(PREV_BUTTON_INACTIVE, meta -> {
                meta.setDisplayName(ChatColor.DARK_GRAY + "\u21e6 " + Slimefun.getLocalization().getMessage(p, "guide.pages.previous"));
                meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")"));
            });
        }
        return new CustomItemStack(PREV_BUTTON_ACTIVE, meta -> {
            meta.setDisplayName(ChatColor.WHITE + "\u21e6 " + Slimefun.getLocalization().getMessage(p, "guide.pages.previous"));
            meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")"));
        });
    }

    @Nonnull
    public static ItemStack getNextButton(@Nonnull Player p, int page, int pages) {
        if (pages == 1 || page == pages) {
            return new CustomItemStack(NEXT_BUTTON_INACTIVE, meta -> {
                meta.setDisplayName(ChatColor.DARK_GRAY + Slimefun.getLocalization().getMessage(p, "guide.pages.next") + " \u21e8");
                meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")"));
            });
        }
        return new CustomItemStack(NEXT_BUTTON_ACTIVE, meta -> {
            meta.setDisplayName(ChatColor.WHITE + Slimefun.getLocalization().getMessage(p, "guide.pages.next") + " \u21e8");
            meta.setLore(Arrays.asList("", ChatColor.GRAY + "(" + page + " / " + pages + ")"));
        });
    }

    public static void drawBackground(@Nonnull ChestMenu menu, int ... slots) {
        for (int slot : slots) {
            menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public static void updateProgressbar(@Nonnull ChestMenu menu, int slot, int timeLeft, int time, @Nonnull ItemStack indicator) {
        Inventory inv = menu.toInventory();
        if (inv == null || inv.getViewers().isEmpty()) {
            return;
        }
        ItemStack item = indicator.clone();
        ItemMeta im = item.getItemMeta();
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        if (im instanceof Damageable) {
            Damageable damageable = (Damageable)im;
            damageable.setDamage((int)ChestMenuUtils.getDurability(item, timeLeft, time));
        }
        im.setDisplayName(" ");
        im.setLore(Arrays.asList(ChestMenuUtils.getProgressBar(timeLeft, time), "", ChatColor.GRAY + NumberUtils.getTimeLeft(timeLeft / 2)));
        item.setItemMeta(im);
        menu.replaceExistingItem(slot, item);
    }

    @Nonnull
    public static String getProgressBar(int time, int total) {
        int i;
        StringBuilder builder = new StringBuilder();
        float percentage = Math.round((float)(total - time) * 100.0f / (float)total * 100.0f / 100.0f);
        builder.append(NumberUtils.getColorFromPercentage(percentage));
        int rest = 20;
        for (i = (int)percentage; i >= 5; i -= 5) {
            builder.append(':');
            --rest;
        }
        builder.append("&7");
        for (i = 0; i < rest; ++i) {
            builder.append(':');
        }
        builder.append(" - ").append(percentage).append('%');
        return ChatColors.color(builder.toString());
    }

    private static short getDurability(@Nonnull ItemStack item, int timeLeft, int max) {
        return (short)(item.getType().getMaxDurability() / max * timeLeft);
    }
}

