/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.events.AncientAltarCraftEvent;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientPedestal;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.AncientAltarListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AncientAltarTask
implements Runnable {
    private final AncientAltarListener listener;
    private final AncientPedestal pedestalItem = (AncientPedestal)SlimefunItems.ANCIENT_PEDESTAL.getItem();
    private final Block altar;
    private final int stepDelay;
    private final Location dropLocation;
    private final ItemStack output;
    private final List<Block> pedestals;
    private final List<ItemStack> items;
    private final Collection<Location> particleLocations = new LinkedList<Location>();
    private final Map<Item, Location> positionLock = new HashMap<Item, Location>();
    private boolean running;
    private int stage;
    private final Player player;

    @ParametersAreNonnullByDefault
    public AncientAltarTask(AncientAltarListener listener, Block altar, int stepDelay, ItemStack output, List<Block> pedestals, List<ItemStack> items, Player player) {
        this.listener = listener;
        this.dropLocation = altar.getLocation().add(0.5, 1.3, 0.5);
        this.stepDelay = stepDelay;
        this.altar = altar;
        this.output = output;
        this.pedestals = pedestals;
        this.items = items;
        this.player = player;
        this.running = true;
        this.stage = 0;
        for (Block pedestal : pedestals) {
            Optional<Item> item = this.pedestalItem.getPlacedItem(pedestal);
            if (!item.isPresent()) continue;
            Item entity = item.get();
            this.positionLock.put(entity, entity.getLocation().clone());
        }
    }

    @Override
    public void run() {
        this.idle();
        if (!this.checkLockedItems()) {
            this.abort();
            return;
        }
        if (this.stage == 36) {
            this.finish();
            return;
        }
        if (this.stage > 0 && this.stage % 4 == 0) {
            this.checkPedestal(this.pedestals.get(this.stage / 4 - 1));
        }
        ++this.stage;
        Slimefun.runSync(this, this.stepDelay);
    }

    private boolean checkLockedItems() {
        for (Map.Entry<Item, Location> entry : this.positionLock.entrySet()) {
            if (!(entry.getKey().getLocation().distanceSquared(entry.getValue()) > 0.1)) continue;
            return false;
        }
        return true;
    }

    private void idle() {
        this.dropLocation.getWorld().spawnParticle(Particle.SPELL_WITCH, this.dropLocation, 16, (double)1.2f, 0.0, (double)1.2f);
        this.dropLocation.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, this.dropLocation, 8, (double)0.2f, 0.0, (double)0.2f);
        for (Location loc : this.particleLocations) {
            this.dropLocation.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, loc, 16, (double)0.3f, (double)0.2f, (double)0.3f);
            this.dropLocation.getWorld().spawnParticle(Particle.CRIT_MAGIC, loc, 8, (double)0.3f, (double)0.2f, (double)0.3f);
        }
    }

    private void checkPedestal(@Nonnull Block pedestal) {
        Optional<Item> item = this.pedestalItem.getPlacedItem(pedestal);
        if (!item.isPresent() || this.positionLock.remove(item.get()) == null) {
            this.abort();
        } else {
            Item entity = item.get();
            this.particleLocations.add(pedestal.getLocation().add(0.5, 1.5, 0.5));
            this.items.add(this.pedestalItem.getOriginalItemStack(entity));
            pedestal.getWorld().playSound(pedestal.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 2.0f);
            this.dropLocation.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, pedestal.getLocation().add(0.5, 1.5, 0.5), 16, (double)0.3f, (double)0.2f, (double)0.3f);
            this.dropLocation.getWorld().spawnParticle(Particle.CRIT_MAGIC, pedestal.getLocation().add(0.5, 1.5, 0.5), 8, (double)0.3f, (double)0.2f, (double)0.3f);
            this.positionLock.remove(entity);
            entity.remove();
            entity.removeMetadata("no_pickup", (Plugin)Slimefun.instance());
        }
    }

    private void abort() {
        this.running = false;
        for (Block b : this.pedestals) {
            this.listener.getAltarsInUse().remove(b.getLocation());
        }
        this.listener.getAltarsInUse().remove(this.altar.getLocation());
        this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 1.0f, 1.0f);
        this.positionLock.clear();
        this.listener.getAltars().remove(this.altar);
    }

    private void finish() {
        if (this.running) {
            AncientAltarCraftEvent event = new AncientAltarCraftEvent(this.output, this.altar, this.player);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
                this.dropLocation.getWorld().playEffect(this.dropLocation, Effect.STEP_SOUND, (Object)Material.EMERALD_BLOCK);
                this.dropLocation.getWorld().dropItemNaturally(this.dropLocation.add(0.0, -0.5, 0.0), event.getItem());
            }
            for (Block b : this.pedestals) {
                this.listener.getAltarsInUse().remove(b.getLocation());
            }
            this.listener.getAltarsInUse().remove(this.altar.getLocation());
            this.listener.getAltars().remove(this.altar);
        } else {
            this.dropLocation.getWorld().playSound(this.dropLocation, Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
        }
    }
}

